<?php

/**
 * Gutenberg Dynamic Stylesheet
 */

header( "Content-type: text/css;" );

global $smof_data;
$prefix = "vntd_";

$vntd_accent_color = '#d71818';

if(array_key_exists('vntd_accent_color', $smof_data)) {
    if($smof_data['vntd_accent_color'] ) {
    	$vntd_accent_color = $smof_data['vntd_accent_color'];
    }
}
?>

.wp-block-freeform.block-library-rich-text__tinymce a,
.block-editor div[data-block] a {
  color: <?php echo esc_html( $vntd_accent_color ); ?>;
}

.wp-block-freeform.block-library-rich-text__tinymce blockquote, .editor-writing-flow blockquote {
  border-left-color: <?php echo esc_html( $vntd_accent_color ); ?> !important;
}

<?php

// Fonts

$font_primary = $smof_data[ $prefix . 'heading_font' ];
$font_secondary = $smof_data[ $prefix . 'body_font' ];

if ( $font_primary && $font_primary != 'Oswald' ) {
	echo '.editor-post-title__block .editor-post-title__input,.block-editor div[data-block] h1,.block-editor div[data-block] h2,.block-editor div[data-block] h3,.block-editor div[data-block] h4,.block-editor div[data-block] h5,.block-editor div[data-block] h6 { font-family:"' . $font_primary . '", Open Sans, Helvetica, sans-serif; }';
}

if ( $font_secondary && $font_secondary != 'Raleway' ) {
	echo '.block-editor div[data-block] p,.editor-writing-flow,.editor-block-list__block p,.editor-writing-flow .editor-block-list__block p, .wp-block-freeform.block-library-rich-text__tinymce body,.wp-block-freeform.block-library-rich-text__tinymce { font-family:"' . $font_secondary . '", Open Sans, Helvetica, sans-serif !important; }';
}

// Font weight

if ( $smof_data[$prefix.'heading_font_weight'] && $smof_data[$prefix.'heading_font_weight'] != 400 ) {
	echo ".editor-post-title__block .editor-post-title__input,.block-editor div[data-block] h1,.block-editor div[data-block] h2,.block-editor div[data-block] h3,.block-editor div[data-block] h4,.block-editor div[data-block] h5,.block-editor div[data-block] h6 { font-weight:" . esc_html( $smof_data[ $prefix . 'heading_font_weight'] ) . "; }";
}


?>
