<?php

// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//		Comments Layout
// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

if ( ! function_exists( 'vntd_comment' ) ) {
  function vntd_comment($comment, $args, $depth) {
     $GLOBALS['comment'] = $comment;
     global $post;
     ?>

  	<li <?php comment_class(); ?> id="comment-<?php comment_ID() ?>">

  		<!-- Comment -->
  		<div class="comment">
  			<!-- Image -->
  			<div class="c-image">
  				<?php echo get_avatar($comment,$size='54'); ?>
  			</div>
  			<!-- Description -->
  			<div class="comment-text">
  				<!-- Reply Button -->

  				<?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth'],'reply_text' => '<i class="fa fa-reply"></i> '. esc_html__('Reply','north')))); ?>
  				<!-- Name -->
  				<h4 class="comment-name uppercase font-primary">
  					<?php echo get_comment_author(); ?>
  				</h4>

  				<!-- Date -->
  				<h5 class="comment-date font-secondary">
  					<?php  echo get_comment_date('d m Y'); ?>
  				</h5>
  				<!-- Description -->
  				<?php comment_text(); ?>
  			</div>
  			<!-- End Description -->
  		</div>
  		<!-- End Comment -->

  	</li>

  <?php
  }
}

// Blog Comments Script

function vntd_comments_script() {
	if(is_singular())
	wp_enqueue_script('comment-reply');
}
add_action('wp_enqueue_scripts', 'vntd_comments_script');


if ( ! function_exists( 'vntd_blog_post_tags' ) ) {
  function vntd_blog_post_tags(){
  	if(has_tag()){
  	?>
  	<p class="post-tags"><?php the_tags('<span>'. esc_html__('Tags','north').': </span>', ', ', '<br />'); ?></p>
  	<?php
  	}
  }
}

if ( ! function_exists( 'vntd_blog_post_nav' ) ) {
  function vntd_blog_post_nav(){
  	?>
  	<div class="divider line"></div>
  	<div id="blog-post-nav" class="blog-navigation">
  		<div class="newer-posts boxed-link"><?php previous_post_link('%link'); ?></div>
  		<div class="older-posts boxed-link"><?php next_post_link('%link'); ?></div>
  	</div>
  	<?php
  }
}

if ( ! function_exists( 'north_meta_enabled' ) ) {
  function north_meta_enabled() {

  	if( !( !is_single() && north_option('blog_meta') == false ) && !( is_single() && north_option('blog_single_meta') == false ) ) {
  		return true;
  	}

  	return false;

  }
}

if ( ! function_exists( 'vntd_post_meta' ) ) {
  function vntd_post_meta() {
  	global $post;

  	?>
  	<div class="classic-meta-section">
  		<?php if( north_option( 'blog_meta_date' ) ) { ?>
  		<span class="vntd-meta-date"><?php the_time('F d, Y'); ?></span>
  		<?php
  		}
  		?>
  		<span class="vntd-meta-love"><i class="fa fa-heart-o"></i> 17</span>
  		<?php
  		if( north_option( 'blog_meta_comments' ) ) {
  		?>
  		<span class="vntd-meta-comments"><a href="<?php echo esc_url( get_permalink( $post->ID ) ) . '#comments'?>" title="<?php esc_html_e('View comments','north');?>"><i class="fa fa-comments-o"></i> <?php comments_number('0', '1', '%'); ?></a></span>
  		<?php
  		}
  		if( north_option( 'blog_meta_categories' ) ) {
  		?>
  		<span class="vntd-meta-categories"><?php the_category(', '); ?></span>
  		<?php
  		}
  		?>
  	</div>
  	<?php

  }
}

if ( ! function_exists( 'vntd_post_tags' ) ) {
  function vntd_post_tags(){

  	$posttags = get_the_tags();

  	if($posttags == NULL) return false;

  	if ($posttags) {
  		echo '<span class="post-meta-tags">';
  		$i = 0;
  		$len = count($posttags);
  		foreach($posttags as $tag) {
  		  echo '<a href="'. esc_url( get_tag_link($tag->term_id) ) .'">';
  		  echo '' . $tag->name;
  		  echo "</a>";
  		   $i++;
  		  if($i != $len) echo ', ';
  		}
  		echo '</span>';
  	}
  }
}

if ( ! function_exists( 'vntd_blog_post_content' ) ) {
  function vntd_blog_post_content() {

  	global $post;

  	$post_format = get_post_format($post->ID);

  	if(!$post_format) {
  		$post_format = 'standard';
  	}

  	$blog_head_class = '';
  	if(has_post_thumbnail($post->ID) && $post_format != 'video') {
  		$blog_head_class = ' inner-head t-shadow';
		}
  	?>

  	<div <?php post_class(); ?>>
  		<!-- Post Header -->
  		<div class="blog-head clearfix<?php echo esc_html( $blog_head_class ); ?>">
  			<!-- Post Date -->
  			<div class="blog-head-left t-center">
  				<!-- Day -->
  				<h6 class="blog-post-date-day uppercase bigger font-primary">
  					<?php the_time('d'); ?>
  				</h6>

  				<!-- Month, Year -->
  				<p class="uppercase font-primary">
  					<?php the_time('M Y'); ?>
  				</p>
  			</div>
  			<!-- End Post Date -->

  			<!-- Post Header -->
  			<a href="<?php echo esc_url( get_permalink($post->ID) ); ?>" class="blog-head-right ex-link t-left">
  				<!-- Header -->
  				<h3 class="blog-post-heading uppercase font-primary">
  					<?php echo esc_html( get_the_title($post->ID) ); ?>
  				</h3>

  				<?php
  				if(get_post_meta($post->ID,'page_subtitle',TRUE)) {
  					echo '<p>' . esc_html( get_post_meta($post->ID,'page_subtitle',TRUE) ) . '</p>';
  				}
  				?>
  			</a>
  			<!-- Post Header -->
  		</div>
  		<!-- Post Header -->

  		<?php if( has_post_thumbnail() ) vntd_post_media(); ?>

  		<!-- Post Details -->
  		<div class="details">

  		<!-- End Post Details -->

          <?php if( north_meta_enabled() ) { // if meta section enabled ?>
              <!-- Post Infos -->
              <div class="post-info">
                  <?php if( north_option( 'blog_meta_author' ) ) { // if author enabled ?>
                      <!-- Post Item -->
                      <a href="<?php echo esc_url( get_the_author_meta( 'user_url') ); ?>" class="post-item">
                          <i class="fa fa-user"></i>
                          <?php the_author(); ?>

                      </a>
                      <?php
                  }
                  if( north_option( 'blog_meta_categories' ) ) { // If tags enabled
                      ?>
                      <!-- Post Item -->
                      <span class="post-item">
  					<i class="fa fa-tags"></i>
                          <?php the_category(', '); ?>
  				</span>
                      <?php
                  }
                  if( north_option( 'blog_meta_comments' ) ) { // if comments count enabled
                      ?>
                      <!-- Post Item -->
                      <a href="<?php echo esc_url( get_permalink($post->ID) ) . '#comments'?>" title="<?php esc_html_e('View comments','north');?>" class="post-item">
                          <i class="fa fa-comments"></i>
                          <?php comments_number('0', '1', '%'); echo ' '; esc_html_e('Comments','north'); ?>
                      </a>
                      <?php
                  }
                  ?>
              </div>
              <!-- End Post Infos -->
          <?php } ?>

          <!-- Post Description -->
    			<?php

    			if(!is_single()) {
    				echo vntd_excerpt(240,true,'post-text');
    			}

    			?>

        </div>
  		<?php

  		if(is_single()) {

              the_content();

          }

  		?>

  	</div>

  	<?php

  }
}

if ( ! function_exists( 'vntd_post_media' ) ) {
  function vntd_post_media() {

  	global $post;


  	$post_format = get_post_format($post->ID);
      //echo 'yes: ' . $post_format;
  	if(!$post_format || $post_format == 'standard' || $post_format == 'image' || $post_format == 'gallery' && !get_post_meta($post->ID,'gallery_images',TRUE)) {

  	    wp_enqueue_script('magnific-popup', '', '', '', true);

  	    wp_enqueue_style('magnific-popup');

  	    $imgurl = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full');

  	?>
  	<div class="single_item mp-gallery">
  		<a href="<?php echo esc_url( $imgurl[0] ); ?>" title="<?php echo get_post_meta( get_post_thumbnail_id($post->ID), '_wp_attachment_image_alt', true); ?>">
  			<img src="<?php echo esc_url( $imgurl[0] ); ?>" alt="<?php echo get_post_meta( get_post_thumbnail_id($post->ID), '_wp_attachment_image_alt', true); ?>">
  		</a>
  	</div>
  	<?php
  	} elseif($post_format == 'gallery') {

  	wp_enqueue_script('magnific-popup', '', '', '', true);
  	wp_enqueue_style('magnific-popup');

  	?>

  	<div class="custom_slider">

  		<ul class="image_slider clearfix mp-gallery">

  			<?php

  			$gallery_images = get_post_meta($post->ID,'gallery_images',TRUE);

  			if($gallery_images) {

  				$ids = explode(",", $gallery_images);

  				foreach($ids as $id) {
  					$imgurl = wp_get_attachment_image_src($id, 'full');
  					echo '<li class="slide"><a href="' . esc_url( $imgurl[0] ) . '" title="'. esc_html( get_post_meta($id, '_wp_attachment_image_alt', true) ) . '"><img src="'. esc_url( $imgurl[0] ) . '" alt="'. esc_attr( get_post_meta($id, '_wp_attachment_image_alt', true) ) . '"></a></li>';
  				}

  			}


  			?>
  		</ul>
  	</div>

  	<?php

  	} elseif($post_format == 'video') {

  		if(!get_post_meta($post->ID, 'video_site_url', true)) echo 'No video URL inserted!';

  		echo '<div class="video-containers single_item">' . wp_oembed_get( get_post_meta($post->ID, 'video_site_url', true) ) . '</div>';
  	}

  }
}

// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
// 		Post Views Count
// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

function vntd_getPostViews($postID){
    $count_key = 'post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
        return "0 View";
    }
    return $count.' Views';
}
function vntd_setPostViews($postID) {
    $count_key = 'post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        $count = 0;
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
    }else{
        $count++;
        update_post_meta($postID, $count_key, $count);
    }
}
