<?php

// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// 		Theme Functions
//
//		Q: Why place theme here instead of the functions.php file?
//		A: WordPress totally breaks if you make any accident changes
//		   to that file.
//
// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-


// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//		Image cropping functions
// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

if ( ! function_exists( 'vntd_thumb' ) ) {
	function vntd_thumb($w,$h = null) {
		require_once get_template_directory() . '/includes/aq_resizer.php';

		global $post;
		$imgurl = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'thumbnail');
		return $imgurl[0];
		return aq_resize($imgurl[0],$w,$h,true);
	}
}

if ( ! function_exists( 'vntd_body_skin' ) ) {
	function vntd_body_skin( $classes ) {

		global $smof_data;

		$return = '';

		if(array_key_exists('vntd_skin', $smof_data)) {
			if($smof_data['vntd_skin'] == 'night' || $smof_data['vntd_skin'] == 'dark') {
				$return .= 'dark-layout';
			}
		}

		if( array_key_exists('vntd_sticky_header', $smof_data) ) {
			if( $smof_data['vntd_sticky_header'] == false ) {
				$return .= ' header-not-sticky';
			} elseif( $smof_data['vntd_sticky_header_mobile'] == false ) {
				$return .= ' header-not-sticky-mobile';
			} else {
				$return .= ' header-sticky';
			}
		}

		if ( $return != '' ) {
			$classes[] = trim( $return, ' ' );
		}

		return $classes;

	}
	add_filter( 'body_class', 'vntd_body_skin' );
}


// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
// 		Pagination
// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-


if ( ! function_exists( 'vntd_pagination' ) ) {
	function vntd_pagination($the_query = NULL) {

		global $wp_query,$paged;

		$big = 999999999; // need an unlikely integer
	    $pages = paginate_links( array(
	            'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
	             'format' => ( ( get_option( 'permalink_structure' ) && ! $wp_query->is_search ) || ( is_home() && get_option( 'show_on_front' ) !== 'page' && ! get_option( 'page_on_front' ) ) ) ? '?paged=%#%' : '&paged=%#%', // %#% will be replaced with page number
	            'current' => max( 1, get_query_var('paged') ),
	            'total' => $wp_query->max_num_pages,
	            'prev_next' => false,
	            'type'  => 'array',
	            'prev_next'   => TRUE,
				'prev_text' => esc_html__('Prev','north'),
				'next_text' => esc_html__('Next','north')
	        ) );
	        if( is_array( $pages ) ) {
	            $paged = ( get_query_var('paged') == 0 ) ? 1 : get_query_var('paged');
	            echo '<div class="blog_pagination t-right"><ul class="pagination">';
	            foreach ( $pages as $page ) {
	                    echo "<li>$page</li>";
	            }
	           echo '</ul></div>';
	        }

	}
}

// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//		Custom Excerpt Size
// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

function vntd_custom_excerpt_length( $length ) {
	return 70; // Increase maximum excerpt size
}
add_filter( 'excerpt_length', 'vntd_custom_excerpt_length', 999 );

if ( ! function_exists( 'vntd_excerpt' ) ) {
	function vntd_excerpt($limit,$more = NULL,$class = NULL) {
		global $post;
		setup_postdata($post);
		$excerpt = explode(' ', get_the_excerpt(), $limit);

		if (count($excerpt)>=$limit) {
			array_pop($excerpt);
			$excerpt = implode(" ",$excerpt).'...';
		}else{
			$excerpt = implode(" ",$excerpt);
		}
		$excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
		$p_class = '';
		if($class) $p_class = ' class="'.$class.'"';
		$output = '<p'.$p_class.'>'.$excerpt.'</p>';

		if ( $more === 'link' ) {
			$output .= '<a href="' . esc_url( get_post_meta($post->ID,"post_link",TRUE) ) . '" class="post-read-more">'. esc_html__('Visit Site','north').'</a>';
		}elseif($more) {
			$output .= '<div class="fullwidth t-right"><a href="'. esc_url( get_permalink($post->ID) ) .'" class="read-more-post ex-link uppercase">'. esc_html__('Read more','north').' <i class="fa fa-angle-right"></i></a></div>';
		}

		return $output;

	}
}

if ( ! function_exists( 'vntd_excerpt_plain' ) ) {
	function vntd_excerpt_plain($limit) {
	      $excerpt = explode(' ', get_the_excerpt(), $limit);

	      if (count($excerpt)>=$limit) {
	        array_pop($excerpt);
	        $excerpt = implode(" ",$excerpt).'...';
	      } else {
	        $excerpt = implode(" ",$excerpt);
	      }

	      $excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
	      return $excerpt;
	}
}

// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//		Post Gallery
// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

if ( ! function_exists( 'vntd_post_gallery' ) ) {
	function vntd_post_gallery($type,$thumb_size) {

		global $post;

		$gallery_images = get_post_meta($post->ID, 'gallery_images', true);

		if(!$gallery_images && has_post_thumbnail()) { // No Gallery Images
			$url = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), $thumb_size);
			return '<img src="'. esc_url( $url[0] ) .'" alt="'. esc_attr( get_the_title($post->ID) ) . '">';
		}

		echo '<div class="vntd-post-gallery vntd-post-gallery-'.$type.'">';

		if($type == "slider") { // Slider Gallery

			echo '<div class="flexslider vntd-flexslider"><ul class="slides">';

			$ids = explode(",", $gallery_images);
			foreach($ids as $id){
				$image_url = wp_get_attachment_image_src($id, $thumb_size);
				echo '<li><img src="'. esc_url( $image_url[0] ) .'" alt></li>';
			}

			echo '</ul></div>';

		} elseif($type == "list" || $type == "list_lightbox") {

			$ids = explode(",", $gallery_images);
			foreach($ids as $id){
				//global $post = $post=>$id;
				$image_url = wp_get_attachment_image_src($id, $thumb_size);
				$big_url = wp_get_attachment_image_src($id, 'fullwidth-auto');
				echo '<div class="vntd-gallery-item">';
				if($type == "list_lightbox") echo '<a href="' . esc_url( $big_url[0] ) .'" class="hover-item" rel="gallery[gallery'. esc_attr( $post->ID ) . ']" title="'. esc_attr( get_post($id)->post_excerpt ) . '"><span class="hover-overlay"></span><span class="hover-icon hover-icon-zoom"></span>';
				echo '<img src="'. esc_url( $image_url[0] ) .'" alt>';
				if($type == "list_lightbox") echo '</a>';
				echo '</div>';
			}

		} else {
			// If Lightbox Gallery
			echo '<div class="featured-image-holder"><div class="gallery clearfix">';

			$ids = explode(",", $gallery_images);
			if($gallery_images) $id = array_shift(array_values($ids));
			$image_url = wp_get_attachment_image_src($id, $thumb_size);
			$large_url = wp_get_attachment_image_src($id, 'large');
			echo '<a class="hover-item" href="' . esc_url( $large_url[0] ) . '" rel="gallery[gallery'. esc_attr( $post->ID ) .']"><img src="'. esc_url( $image_url[0] ) .'"><span class="hover-overlay"></span><span class="hover-icon hover-icon-zoom"></span></a>';

				if($gallery_images){

					echo '<div class="lightbox-hidden">';
					foreach(array_slice($ids,1) as $id){
						echo '<a href="' . esc_url( wp_get_attachment_url( $id ) ) . '" rel="gallery[gallery'. esc_attr( $post->ID ) .']"></a>';
					}
					echo '</div>';

				}

			echo '</div></div>';

		}

		echo '</div>';
	}
}

if ( ! function_exists( 'vntd_gallery_metabox' ) ) {
	function vntd_gallery_metabox($gallery_images) {

		$modal_update_href = esc_url( add_query_arg( array(
		     'page' => 'shiba_gallery',
		     '_wpnonce' => wp_create_nonce('shiba_gallery_options'),
		 ), admin_url('upload.php') ) );
		 ?>

		 <div class="vntd-gallery-thumbs">
		 	<?php

	 		if($gallery_images){

	 			$ids = explode(",", $gallery_images);

	 			foreach($ids as $id){
	 				echo '<img src="'. esc_url( wp_get_attachment_thumb_url($id) ) .'" alt>';
	 			}

	 		}

		 	?>
		 </div>

		 <input type="text" class="hidden" id="gallery_images" name="gallery_images" value="<?php echo esc_html( $gallery_images ); ?>">
		 <?php if($gallery_images) { $button_text = esc_html__("Modify Gallery", "north"); } else { $button_text = esc_html__("Create Gallery", "north"); } ?>
		 <a id="vntd-gallery-add" class="button" href="#"
		     data-update-link="<?php echo esc_attr( $modal_update_href ); ?>"
		     data-choose="<?php esc_html_e('Choose a Default Image', "north"); ?>"
		     data-update="<?php esc_html_e('Set as default image', "north"); ?>"><?php echo '' . $button_text; ?>
		 </a>
		 <?php if($gallery_images){ ?><span class="vntd-gallery-or">
		 <?php esc_html_e('or', 'north') ?> </span><input type="button" id="vntd-gallery-remove" class="button" value="Remove Gallery">


		 <?php
		 }
		 // Add to the top of our data-update-link page
		 if (isset($_REQUEST['file'])) {
		     check_admin_referer("shiba_gallery_options");

		         // Process and save the image id
		     $options = get_option('shiba_gallery_options', TRUE);
		     $options['default_image'] = absint($_REQUEST['file']);
		     update_option('shiba_gallery_options', $options);

		}

	}
}

if ( ! function_exists( 'vntd_get_id' ) ) {
	function vntd_get_id() {

		global $post;

		$post_id = '';

		if(is_object($post)) {
			$post_id = $post->ID;
		}
		if(is_home()) {
			$post_id = get_option('page_for_posts');
		}

	    if ( class_exists( 'Woocommerce' ) ) {
	        if ( is_shop() || is_cart() || is_checkout() || is_account_page() ) {
	            $post_id = get_option( 'woocommerce_shop_page_id' );
	        }
	    }

		return $post_id;
	}
}

if ( ! function_exists( 'vntd_fonts' ) ) {
	function vntd_fonts() {

		global $smof_data;

		$font_body = 'Raleway';
		$font_heading = 'Oswald';
		$font_weight = $nav_font_weight = '';


		if(array_key_exists('vntd_body_font', $smof_data)) {
		if($smof_data['vntd_body_font'] && $smof_data['vntd_body_font'] != $font_body && $smof_data['vntd_body_font'] != 'none' ) {
			$font_body = $smof_data['vntd_body_font'];
		}
		}
		if(array_key_exists('vntd_heading_font', $smof_data)) {
		if($smof_data['vntd_heading_font'] && $smof_data['vntd_heading_font'] != $font_heading && $smof_data['vntd_heading_font'] != 'none' ) {
			$font_heading = $smof_data['vntd_heading_font'];
		}
		}

		$font_heading_weight = ':300,400';
		if(array_key_exists('vntd_heading_font_weight', $smof_data)) {
			$font_weight = $smof_data['vntd_heading_font_weight'];
		}
		if(!$font_weight) $font_weight = 400;

		$font_heading_weight = ':300,'.$font_weight;

		//$font_heading_weight = ':300,400,500,600,700';

		if(array_key_exists('vntd_navigation_font_weight', $smof_data)) {
		$nav_font_weight = $smof_data['vntd_navigation_font_weight'];
		}
		if(!$nav_font_weight) $nav_font_weight = 600;

		if($nav_font_weight != $font_weight && $nav_font_weight != 300) {
			$font_heading_weight .= ','.$nav_font_weight;
		}

		if($font_body != $font_heading && strpos($font_body, ',') === false && $font_body != 'Arial' ) {
			wp_enqueue_style('google-font-body', '//fonts.googleapis.com/css?family='.str_replace(' ','+', $font_body ) );
		}

		if( strpos($font_heading, ',') === false && $font_heading != 'Arial') {
		    $font_slug = str_replace(' ','+', $font_heading );
		    if ( $font_heading == 'GFS Didot' || $font_heading == 'Ovo' ) {
		        $font_heading_weight = '';
	            wp_enqueue_style('google-font-heading', '//fonts.googleapis.com/css?family=' . $font_slug );
	        } else {
	            wp_enqueue_style('google-font-heading', '//fonts.googleapis.com/css?family=' . $font_slug . $font_heading_weight );
	        }

		}
		wp_enqueue_style('google-font-third', '//fonts.googleapis.com/css?family=Indie+Flower');

	}
	add_action( 'wp_enqueue_scripts', 'vntd_fonts' );
	add_action( 'admin_enqueue_scripts', 'vntd_fonts' );
}

if ( ! function_exists( 'vntd_print_social_icons' ) ) {
	function vntd_print_social_icons() {

		global $smof_data;
		$target = '';

		if(array_key_exists('vntd_social_icons',$smof_data)) {
			if($smof_data['vntd_social_icons']) {
				echo '<div class="vntd-social-icons">';
				if($smof_data['vntd_social_icons_target']) {
					$target = ' target="_blank"';
				}
				foreach($smof_data['vntd_social_icons'] as $social_icon)
				{
					echo '<a class="social-'.strtolower( esc_attr( $social_icon['icon_name'] ) ).'" href="' . esc_url( $social_icon['url'] ) . '"'.$target.'><i class="fa fa-'.strtolower($social_icon['icon_name']).'"></i></a>';
				}
				echo '</div>';
			}
		}
	}
}

// Footer Widgets related functions

if ( ! function_exists( 'vntd_get_footer_cols' ) ) {
	function vntd_get_footer_cols() {

		if(is_active_sidebar('footer1') && is_active_sidebar('footer2') && is_active_sidebar('footer3') && is_active_sidebar('footer4')) {
			return 4;
		} elseif(is_active_sidebar('footer1') && is_active_sidebar('footer2') && is_active_sidebar('footer3')) {
			return 3;
		} elseif(is_active_sidebar('footer1') && is_active_sidebar('footer2')) {
			return 2;
		} else {
			return 1;
		}

		return 0;
	}
}

if ( ! function_exists( 'vntd_get_footer_cols_class' ) ) {
	function vntd_get_footer_cols_class() {

		$widget_col_class = 'col-xs-3';

		if(vntd_get_footer_cols() == 1) {
			$widget_col_class = 'col-md-12';
		} elseif(vntd_get_footer_cols() == 2) {
			$widget_col_class = 'col-md-6';
		} elseif(vntd_get_footer_cols() == 3) {
			$widget_col_class = 'col-md-4';
		}

		return $widget_col_class;
	}
}

if ( ! function_exists( 'vntd_get_footer_cols_class' ) ) {
	function vntd_get_footer_cols_class() {

		global $smof_data;

		if($smof_data['vntd_footer_widgets_skin'] == 'dark') {
			return 'footer-widgets-dark';
		} elseif($smof_data['vntd_footer_widgets_skin'] == 'night') {
			return 'footer-widgets-night';
		} elseif($smof_data['vntd_footer_widgets_skin'] == 'dark') {
			return 'footer-widgets-white';
		} else {

		}

		return 'footer-widgets-white';

	}
}

if( !function_exists('north_vc_active') ) {
	function north_vc_active( $the_post_id = null ) { // Function to check if Visual Composer is enabled on a specific page.

		$found = false;

		if ( $the_post_id == null ) {

			global $post;

			if ( is_object($post) ) {
				$post_to_check = get_post($post->ID);
			} else {
				return $found;
			}

		} else {
			$post_to_check = get_post( $the_post_id );
		}

		// check the post content for the short code
		if ( stripos($post_to_check->post_content, '[vc_row') !== false ) {
		    // we have found the short code
		    $found = true;
		}

		if ( is_home() && $the_post_id == null ) {
			$found = false;
		}

		// return our final results
		return $found;

	}
}

if( !function_exists( 'north_option' ) ) {
	function north_option( $option_name ) {

		global $smof_data;

		if ( strpos( $option_name, 'vntd_' ) !== false) {

		} else {
			$option_name = 'vntd_' . $option_name;
		}

		if( array_key_exists( $option_name, $smof_data ) ) {
			return $smof_data[ $option_name ];
		} else {
			return null;
		}

		return array();
	}
}

if( !function_exists( 'vntd_icon_select' ) ) {
	function vntd_icon_select( $name, $selected_icon = false, $multiple = false ) {

		$icons = north_fa_array();

		echo '<ul id="vntd-icon-select">';
		if ( is_array( $icons ) ) {
			foreach ( $icons as $icon => $key ) {
				$selected = '';
				if( $icon == $selected_icon ) $selected = 'checked="checked"';
				echo '<li><input type="radio" id="icon-' . esc_attr( $icon ) .'" name="' . esc_attr( $name ) . '" value="' . esc_attr( $icon ) . '"' . $selected . '><label for="icon-' . esc_attr( $icon ) . '"><i class="fa ' . esc_attr( $icon ) . '"></i></label></li>';
			}
		}
		echo '</ul>';

	}
}

if ( ! function_exists( 'north_kses' ) ) {
	function north_kses() {
		$allowed_html_tags = array(
			'a' => array(
				'href' => array(),
				'alt' => array(),
				'text' => array(),
				'class' => array(),
				'target' => array()
			),
			'p' => array(
				'class' => array()
			),
			'br' => array(),
			'span' => array(
				'class' => array(),
			),
			'span' => array(
				'class' => array()
			),
			'i' => array(
				'class' => array()
			),
			'strong' => array(),
			'br' => array(),
			'img' => array(
				'src' => array(),
				'title' => array(),
				'alt' => array(),
				'srcset' => array(),
				'target' => array()
			)
		);
		return apply_filters( 'north_allowed_html_tags', $allowed_html_tags );
	}
}

// Theme Update check
if ( ! function_exists( 'north_core_metaboxes' ) ) {

	//
	// Admin upgrade notice
	//

	if ( ! function_exists( 'north_upgrade_admin_notice' ) ) {
		function north_upgrade_admin_notice() {
			if ( function_exists( 'north_core_shortcodes' ) ) {
				// Check if the notice was already dismissed
				if ( get_option( 'north_upgrade_notice_dismissx' ) == 'dismissed' ) return;
		    ?>
		    <div class="vntd-upgrade-notice notice notice-warning is-dismissible">
		       <strong><?php echo '<p>' . esc_html__( "Please update the North Core plugin to the latest version via", 'north' ) . ' <a href="' . esc_url( admin_url( 'themes.php?page=install-required-plugins' ) ) .'">' . esc_html__( 'Appearance / Install Plugins', 'north' ) . '</a>.</p><p><a href="' . esc_url( add_query_arg( 'north-upgrade-notice-dismiss', 'true' ) ) .'">' . esc_html__( 'Dismiss this notice', 'north' ) . '</a></p>'; ?></strong>
		    </div>
		    <?php
			}
		}
		add_action( 'admin_notices', 'north_upgrade_admin_notice' );
	}

	// Dismiss the notice
	if ( ! function_exists( 'north_upgrade_notice_dismiss' ) ) {
		function north_upgrade_notice_dismiss() {
	    if ( isset( $_GET['north-upgrade-notice-dismiss'] ) ) {
				add_option( 'north_upgrade_notice_dismiss', 'dismissed' );
			}
		}
		add_action( 'admin_init', 'north_upgrade_notice_dismiss' );
	}

}
