<?php

//
// Blog Metaboxes
//

add_action("admin_init", "vntd_blog_post_settings");

// Add Blog Metaboxes
function vntd_blog_post_settings(){
    add_meta_box("blog_gallery_post_format", esc_html__("Gallery Settings",'north'), "vntd_blog_gallery_settings_config", "post", "normal", "high");
    add_meta_box("blog_video_post_format", esc_html__("Video Settings",'north'), "vntd_blog_video_settings_config", "post", "normal", "high");
}

function vntd_blog_post_settings_config(){
        global $post;
        if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ) return $post_id;
        $custom = get_post_custom($post->ID);
		$thumb_setting = $thumb_height = $thumb_lightbox = '';
		if(isset($custom["thumb_setting"][0])) $thumb_setting = $custom["thumb_setting"][0];
		if(isset($custom["thumb_height"][0])) $thumb_height = $custom["thumb_height"][0];
		if(isset($custom["thumb_lightbox"][0])) $thumb_lightbox = $custom["thumb_lightbox"][0];
?>
    <div class="form-table custom-table fullwidth-metabox">
    	<div class="metabox-option">

    	    <h6><?php esc_html_e('Thumbnail Display', 'north') ?>:</h6>
    	    <div class="metabox-option-side">
    	    <?php

    	    $thumb_setting_arr = array("Display thumbnail on single post page" => "on", "Do NOT display the thumbnail on post page" => "off");

    	    vntd_create_dropdown('thumb_setting',$thumb_setting_arr,$thumb_setting);

    	    ?>
    	    </div>
    	</div>
    	<div class="metabox-option">
    	    <h6><?php esc_html_e('Thumbnail Lightbox', 'north') ?>: <span class="form-caption">(<?php esc_html_e('standard post format', 'north') ?>)</span></h6>
    	    <div class="metabox-option-side">
    	    <?php

    	    $thumb_lightbox_arr = array("Disable lightbox" => "off","Enable lightbox zoom of thumbnail image" => "on");

    	    vntd_create_dropdown('thumb_lightbox',$thumb_lightbox_arr,$thumb_lightbox);

    	    ?>

    	    </div>
    	</div>
    	<div class="metabox-option">
            <h6><?php esc_html_e('Thumbnail Height', 'north') ?>:</h6>
            <div class="metabox-option-side">
        	<?php

        	$thumb_heights = array("Landscape" => "landscape", "Original Aspect Ratio" => "auto");

        	vntd_create_dropdown('thumb_height',$thumb_heights,$thumb_height);

        	?>
            </div>
       </div>

    </div>
<?php
}

// Gallery Metabox

function vntd_blog_gallery_settings_config(){
        global $post;
        if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ) return $post_id;
        $custom = get_post_custom($post->ID);
        $gallery_type = $gallery_images = '';
		if(isset($custom["gallery_type"][0])) $gallery_type = $custom["gallery_type"][0];
		if(isset($custom["gallery_images"][0])) $gallery_images = $custom["gallery_images"][0];
?>
    <div class="form-table custom-table fullwidth-metabox">
    	<!--<div class="metabox-option">
    		<h6><?php esc_html_e('Gallery Type', 'north') ?>:</h6>
    	    <div class="metabox-option-side">
    	    <?php

    	    $gallery_types = array("Lightbox" => "lightbox", "Slider" => "slider");

    	    vntd_create_dropdown('gallery_type',$gallery_types,$gallery_type);

    	    ?>
    	    </div>
    	</div>-->
    	<div class="metabox-option">
    		<h6><?php esc_html_e('Gallery Images', 'north') ?>:</h6>

    		<div class="metabox-option-side">
    		<?php vntd_gallery_metabox($gallery_images); ?>
    		</div>
    	</div>
    </div>
<?php
}


// Video Metabox


function vntd_blog_video_settings_config(){
        global $post;
        if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ) return $post_id;
        $custom = get_post_custom($post->ID);
        $video_site_url = '';
		if(isset($custom["video_site_url"][0])) $video_site_url = $custom["video_site_url"][0];
?>
    <div class="form-table custom-table fullwidth-metabox">
    	<div class="metabox-option">
    		<h6><?php esc_html_e('Video URL', 'north') ?>:<span class="form-caption">(<a target="_blank" href="https://codex.wordpress.org/Embeds#Okay.2C_So_What_Sites_Can_I_Embed_From.3F"> <?php esc_html_e('List of supported sites', 'north') ?></a>)</span></h6>

    		<div class="metabox-option-side">
    	    <td class="description-textarea">
    	    	<input type="text" name="video_site_url" value="<?php echo '' . $video_site_url; ?>">
    	    </td>
    	    </div>
    	</div>
    </div>
<?php
}


// Save Custom Fields

add_action('save_post', 'vntd_save_post_settings');

function vntd_save_post_settings() {

    global $post;

    if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ){
		//return $post_id;
	}else{
		if(isset($_POST["page_title"])) update_post_meta($post->ID, "page_title", sanitize_text_field( $_POST["page_title"] ));
		if(isset($_POST["tagline"])) update_post_meta($post->ID, "tagline", sanitize_text_field( $_POST["tagline"] ));
		if(isset($_POST["page_layout"])) update_post_meta($post->ID, "page_layout", sanitize_text_field( $_POST["page_layout"] ));
		if(isset($_POST["page_sidebar"])) update_post_meta($post->ID, "page_sidebar", sanitize_text_field( $_POST["page_sidebar"] ));
		if(isset($_POST["thumb_setting"])) update_post_meta($post->ID, "thumb_setting", sanitize_text_field( $_POST["thumb_setting"] ));
		if(isset($_POST["thumb_height"])) update_post_meta($post->ID, "thumb_height", sanitize_text_field( $_POST["thumb_height"] ));
		if(isset($_POST["thumb_lightbox"])) update_post_meta($post->ID, "thumb_lightbox", sanitize_text_field( $_POST["thumb_lightbox"] ));
		if(isset($_POST["gallery_type"])) update_post_meta($post->ID, "gallery_type", sanitize_text_field( $_POST["gallery_type"] ));
		if(isset($_POST["gallery_images"])) update_post_meta($post->ID, "gallery_images", sanitize_text_field( $_POST["gallery_images"] ));
		if(isset($_POST["video_site_url"])) update_post_meta($post->ID, "video_site_url", sanitize_text_field( $_POST["video_site_url"] ));
		if(isset($_POST["video_file_url"])) update_post_meta($post->ID, "video_file_url", sanitize_text_field( $_POST["video_file_url"] ));
    }

}
