<?php

/*

Plugin Name: 	North Core
Plugin URI: 	http://themeforest.net/user/Veented
Description: 	Core functionalities for North WordPress Theme. This plugin was developed to meet the new ThemeForest requirements and will soon be required for the theme to work correctly. However, until November 2019, we're allowed to keep those core functionalities in the theme as a fallback so the theme will continue to work without this plugin until that time. But it is highly recommended to have the North Core plugin active right now to avoid any transition issues.
Version: 		1.5.2
Author: 		Veented
Author URI: 	http://themeforest.net/user/Veented
License: 		GPL2

*/

// North Theme Check

$theme = wp_get_theme();
$theme_name = 'North';
if ( $theme_name != $theme->name && $theme_name != $theme->parent_theme ) return;

define( 'NORTH_CORE_PATH', dirname( __FILE__ ) );

// Proceed

if ( ! function_exists( 'vntd_portfolio_register' ) ) { // Fallback for plugin activation

  // Custom post types
  if ( ! function_exists( 'north_core_post_types' ) ) {
    function north_core_post_types() {
      require_once( NORTH_CORE_PATH . '/custom-post-types/portfolio/portfolio-functions.php');
      require_once( NORTH_CORE_PATH . '/custom-post-types/services/services-functions.php');
      require_once( NORTH_CORE_PATH . '/custom-post-types/team/team-functions.php');
      require_once( NORTH_CORE_PATH . '/custom-post-types/testimonials/testimonials-functions.php');
    }
    north_core_post_types();
  }

  // Shortcodes
  if ( ! function_exists( 'north_core_shortcodes' ) ) {
    function north_core_shortcodes() {
      require_once( NORTH_CORE_PATH . '/shortcodes/shortcodes.php');
    }
    north_core_shortcodes();
  }

  // Widgets
  if ( ! function_exists( 'north_core_widgets' ) ) {
    function north_core_widgets() {
      require_once( NORTH_CORE_PATH . '/widgets/widget-flickr.php');
    }
    north_core_widgets();
  }

  // Metaboxes
  if ( ! function_exists( 'north_core_metaboxes' ) ) {
    function north_core_metaboxes() {
      require_once( NORTH_CORE_PATH . '/metaboxes/metaboxes-main.php');
      require_once( NORTH_CORE_PATH . '/metaboxes/metaboxes-blog.php');
    }
    north_core_metaboxes();
  }

  // Admin bar
  if ( ! function_exists( 'north_admin_bar_options_button' ) ) {
  	function north_admin_bar_options_button() {
  		global $wp_admin_bar;
  		if (!is_super_admin() || !is_admin_bar_showing())
  			return;
  		$wp_admin_bar->add_menu( array(
  			'id' 	=> 'theme_options',
  			'title' => esc_html__( 'Theme Options', 'north'),
  			'href' 	=> admin_url( 'admin.php?page=optionsframework'),
  		));
  	}
  	add_action( 'admin_bar_menu', 'north_admin_bar_options_button', 35 );
  }

  // Shortcode filter
  add_filter( 'widget_text', 'do_shortcode' );

  // Theme Options

  // Encode data
  if ( ! function_exists( 'north_options_encode_data' ) ) {
    function north_options_encode_data( $data ) {
      return base64_encode( serialize( $data ) );
    }
  }

  // Decode data
  if ( ! function_exists( 'north_options_decode_data' ) ) {
    function north_options_decode_data( $data ) {
      return unserialize( base64_decode( $data ) );
    }
  }

}

// Translation
function north_core_load_textdomain() {
    load_plugin_textdomain( 'north', FALSE, basename( dirname( __FILE__ ) ) . '/lang' );
}
add_action( 'plugins_loaded', 'north_core_load_textdomain' );

?>
