<?php

// Shortcode init

function vntd_team_member($atts, $content = null)
{
    extract(shortcode_atts(array(
        "name" => 'John Doe',
        "description" => '',
        "position" => '',
        "img" => '',
        "facebook" => '',
        "twitter" => '',
        "googleplus" => '',
        "linkedin" => '',
        "pinterest" => '',
        "email" => '',
        "dribbble" => '',
        "instagram" => '',
        "youtube" => '',
        "tumblr" => '',
        "target" => '_blank'
    ), $atts));

    $icon_arr = array(
        'facebook',
        'twitter',
        'googleplus',
        'tumblr',
        'pinterest',
        'instagram',
        'dribbble',
        'linkedin',
        'youtube',
        'email'
    );

    $socials = '<div class="vntd-social-icons vntd-social-icons-default vntd-social-icons-small">';
    foreach ($icon_arr as $icon_name) {
        if (isset($atts[$icon_name])) {
            $socials .= '<a href="' . $atts[$icon_name] . '" class="vntd-social-icon vntd-icon vntd-not-accent vntd-icon-' . $icon_name . '" target="' . esc_attr($target) . '"></a>';
        }
    }
    $socials .= '</div>';

    if (is_numeric($img)) {
        $img = wp_get_attachment_image_src($img, 'portfolio-square');
        $img = $img[0];
    } elseif (strpos($img, 'http://') !== false) {
        $img = $img;
    } else {
        $img = "http://placehold.it/350x240";
    }

    return '<div class="vntd-person"><img class="vntd-person-pic" src="' . $img . '" title="' . $name . '"><h4 class="vntd-person-name">' . $name . '</h4><div class="vntd-person-role">' . $position . '</div><div class="vntd-person-text">' . $description . '</div><div class="vntd-person-social">' . $socials . '</div></div>';
}
remove_shortcode('team_member');
add_shortcode('team_member', 'vntd_team_member');
