<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>

    <meta charset="<?php bloginfo( 'charset' ); ?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

    <?php	wp_head(); ?>

</head>

<body <?php body_class(); ?>>

	<section id="home"></section>

	<?php

  global $smof_data;

	if( array_key_exists( 'vntd_loader', $smof_data ) ) { if( $smof_data['vntd_loader'] || !isset($smof_data['vntd_loader'])) {

		$loader_class = 'dark-border';
		$vntd_skin = '';
		if(array_key_exists('vntd_skin', $smof_data)) {
			$vntd_skin = $smof_data['vntd_skin'];
		}
		if($vntd_skin == 'dark') {
			$loader_class = 'colored-border';
		}

		?>
		<!-- Page Loader -->
		<section id="pageloader" class="white-bg">
			<div class="outter <?php echo esc_attr( $loader_class ); ?>">
				<div class="mid <?php echo esc_attr( $loader_class ); ?>"></div>
			</div>
		</section>
		<?php

	}}

    do_action( 'north_before_header' );

	if(vntd_navbar_style('style') != 'disable') {

	?>



	<nav id="navigation<?php echo vntd_navbar_style('id'); ?>" class="<?php echo vntd_navbar_style(); ?>">

		<div class="nav-inner">
			<div class="logo">
				<!-- Navigation Logo Link -->
				<a href="<?php vntd_logo_url(); ?>" class="scroll">
					<?php
					$navbar_color = '';
					if(array_key_exists('vntd_navbar_color', $smof_data)) {
						$navbar_color = $smof_data['vntd_navbar_color'];
					}
					if( array_key_exists( 'vntd_logo_url', $smof_data ) && $smof_data['vntd_logo_url'] != '' ) {

						if(vntd_navbar_style('style') == 'style2' && $smof_data['vntd_logo_light_url'] && get_post_meta(vntd_get_id(),'navbar_color',TRUE) != 'white' || $navbar_color == 'dark' && $smof_data['vntd_logo_light_url']) {
							$logo_url = $smof_data['vntd_logo_light_url'];
						} else {
							$logo_url = $smof_data['vntd_logo_url'];
						}

						echo '<img class="site_logo" src="'.$logo_url.'" alt="'.get_bloginfo().'">';
					} else {
            echo '<h3 class="site-text-logo">' . get_bloginfo() . '</h3>';
          }
					?>
				</a>
			</div>
      <?php do_action( 'north_before_mobile_nav_button' ); ?>
			<!-- Mobile Menu Button -->
			<a class="mobile-nav-button colored"><i class="fa fa-bars"></i></a>
			<!-- Navigation Menu -->
			<div class="nav-menu nav-menu-desktop clearfix semibold">

				<?php

				if (has_nav_menu('primary')) {
					wp_nav_menu( array('theme_location' => 'primary','container' => false,'menu_class' => 'nav uppercase font-primary','walker' => new Vntd_Custom_Menu_Class()));
				} else {
					echo '<span class="vntd-no-nav">No custom menu created!</span>';
				}

				if( class_exists('Woocommerce') && north_option( 'topbar_woocommerce' ) ) vntd_woo_nav_cart();

				?>

			</div>
			<div class="nav-menu nav-menu-mobile clearfix semibold">

				<?php

				if (has_nav_menu('primary')) {
					wp_nav_menu( array('theme_location' => 'primary','container' => false,'menu_class' => 'nav uppercase font-primary','walker' => new Vntd_Custom_Menu_Class()));
				} else {
					echo '<span class="vntd-no-nav">No custom menu created!</span>';
				}

				if(class_exists('Woocommerce') && north_option( 'topbar_woocommerce' ) ) vntd_woo_nav_cart();

				?>

			</div>
		</div>
	</nav>

	<?php

	}

    do_action( 'north_before_page_title' );

	if(!is_front_page() && north_option( 'header_title' ) != 0 && get_post_meta(vntd_get_id(), 'page_header', true) != 'no-header' && !is_404() && !is_page_template('template-onepager.php')) {
		vntd_print_page_title();
	}

    do_action( 'north_after_page_title' );

	?>

	<div id="page-content">
