<?php

//
// Custom Visual Composer Scripts for a Theme Integration
//

if ( ! has_filter( 'north_vc_enable_frontend_editor' ) ) {
	vc_disable_frontend();
}

// Fade Animation for elements

function vntd_vc_animation( $css_animation ) {
	$animation_data = '';

	if($css_animation != '') {
		$animation_data = ' data-animation="';
		if($css_animation == 'left-to-right') {
			$animation_data .= 'fadeInLeft';
		} elseif($css_animation == 'right-to-left') {
			$animation_data .= 'fadeInRight';
		} elseif($css_animation == 'top-to-bottom') {
			$animation_data .= 'fadeInTop';
		} elseif($css_animation == 'bottom-to-top') {
			$animation_data .= 'fadeInBottom';
		} else {
			$animation_data .= 'fadeIn';
		}
		$animation_data .= '" data-animation-delay="100"';
	}
	return $animation_data;
}

// VC Row

if ( north_option( 'vntd_vc_default' ) != true ) {

	vc_add_param("vc_row", array(
	    "type" => "textfield",
	    "heading" => esc_html__("Row ID", "north"),
	    "param_name" => "el_id",
	    "value" => "",
	    "description" => esc_html__("Row's unique ID.", "north")
	));

	if ( ! has_filter( 'north_enable_vc_row_params' ) ) {
		vc_remove_param("vc_row","font_color");
		vc_remove_param("vc_row","full_width");
	}

	vc_add_param("vc_row", array(
		'type' => 'css_editor',
		'heading' => esc_html__( 'Css', 'north' ),
		'param_name' => 'css',
		'group' => esc_html__( 'Design options', 'north' )
	));

	vc_add_param("vc_row", array(
		"type" => "dropdown",
		"class" => "",
		"heading" => esc_html__("Font Color Scheme", 'north'),
		"param_name" => "color_scheme",
		"value" => array(
			esc_html__( "Default", 'north' ) => "",
			esc_html__( "White Scheme", 'north' ) => "white",
			esc_html__( "Custom", 'north' ) => "custom"
		),
		"description" => esc_html__("White Scheme - all text styled to white color, recommended for dark backgrounds. Custom - choose your own heading and text color.", 'north'),
	));

		vc_add_param("vc_row", array(
		  "type" => "colorpicker",
		  "heading" => esc_html__("Heading Color", "north"),
		  "param_name" => "customcolor_heading",
		  "class" => "hidden-label",
		  "description" => esc_html__("Custom color for section headings.", "north"),
		  "dependency" => Array('element' => "color_scheme", 'value' => array('custom'))
		));

		vc_add_param("vc_row", array(
		  "type" => "colorpicker",
		  "heading" => esc_html__("Text Color", "north"),
		  "param_name" => "customcolor_text",
		  "class" => "hidden-label",
		  "description" => esc_html__("Custom color for section paragraph texts.", "north"),
		  "dependency" => Array('element' => "color_scheme", 'value' => array('custom'))
		));

	vc_add_param("vc_row", array(
		"type" => "dropdown",
		"class" => "",
		"heading" => "Parallax Effect",
		"param_name" => "parallax",
		"value" => array(
			esc_html__( "No", 'north' ) => "",
			esc_html__( "Yes", 'north' ) => "yes"
		),
		"description" => esc_html__("Enable or disable the parallax effect. Available only if background image is set in the 'Design Options' tab.", 'north'),
	));

	vc_add_param("vc_row", array(
		"type" => "dropdown",
		"class" => "",
		"heading" => "Background Image Overlay",
		"param_name" => "bg_overlay",
		"value" => array(
			esc_html__( "None", 'north' ) => "",
			esc_html__( "Dark", 'north' ) => "dark",
			esc_html__( "Darker", 'north' ) => "darker",
			esc_html__( "Light", 'north' ) => "light",
			esc_html__( "White Dots", 'north' ) => 'dots_white',
			esc_html__( "Dark Dots", 'north' ) => 'dots_dark'
		),
		"description" => esc_html__("Enable the row's background verlay to darken or lighten the background image.", 'north'),
	));

	vc_add_param("vc_row", array(
		"type" => "dropdown",
		"class" => "",
		"heading" => "Background Image Rain Effect",
		"param_name" => "bg_rain",
		"value" => array(
			esc_html__( "No", 'north' ) => "",
			esc_html__( "Yes", 'north' ) => "yes"
		),
		"description" => esc_html__("Enable the Rain Effect over the row's background image.", 'north'),
	));

		vc_add_param("vc_row", array(
			"type" => "dropdown",
			"class" => "",
			"heading" => "Rain Sound Effects",
			"param_name" => "bg_rain_sound",
			"value" => array(
				esc_html__( "No", 'north' ) => "",
				esc_html__( "Yes", 'north' ) => "yes"
			),
			"description" => esc_html__("Enable or disable the rain sound effect playing in a background.", 'north'),
			"dependency" => Array('element' => "bg_rain", 'value' => 'yes')
		));

	vc_add_param("vc_row", array(
		"type" => "dropdown",
		"class" => "",
		"heading" => esc_html__("Row's Content Width", 'north'),
		"param_name" => "content_width",
		"value" => array(
			esc_html__( "Container", 'north' ) => "container",
			esc_html__( "Fullwidth", 'north' ) => "fullwidth"
		),
		"description" => esc_html__("Make the row's content width fullwidth. Useful for fullwidth Portfolio Grid or Portfolio Carousel.","north")
	));

	vc_add_param("vc_row", array(
		"type" => "dropdown",
		"class" => "",
		"heading" => "Fullscreen",
		"param_name" => "fullscreen",
		"value" => array(
			esc_html__( "No", 'north' ) => "",
			esc_html__( "Yes", 'north' ) => "yes"
		),
		"description" => esc_html__("Make the row's height and width fullscreen' tab. Suitable mainly for 'Fancy Text Blocks'.", 'north'),
	));

	vc_add_param("vc_row", array(
		"type" => "dropdown",
		"class" => "",
		"heading" => "Video Background",
		"param_name" => "video_bg",
		"value" => array(
			esc_html__( "No", 'north' ) => "",
			"YouTube" => "youtube",
			"Vimeo" => "vimeo"
		),
		"group" => esc_html__( 'Video Background', 'north' ),
		"description" => esc_html__("Enable a Video Background", 'north'),
	));

	vc_add_param("vc_row", array(
		"type" => "textfield",
		"class" => "",
		"heading" => "YouTube Video ID",
		"param_name" => "video",
		"value"	=> '',
		"description" => esc_html__("Enter the YouTube video's ID to be displayed as the row background. Example: mSLAF_DjiDU", 'north'),
		"group" => esc_html__( 'Video Background', 'north' ),
		"dependency" => Array('element' => "video_bg", 'value' => 'youtube')
	));

	vc_add_param("vc_row", array(
		"type" => "textfield",
		"class" => "",
		"heading" => "Vimeo ID",
		"param_name" => "vimeo",
		"value"	=> '',
		"description" => esc_html__("Enter the Vimeo video's ID to be displayed as the row background. Example: 51287059", 'north'),
		"group" => esc_html__( 'Video Background', 'north' ),
		"dependency" => Array('element' => "video_bg", 'value' => 'vimeo')
	));

	vc_add_param("vc_row", array(
		"type" => "dropdown",
		"class" => "",
		"heading" => "Video Autoplay",
		"param_name" => "video_autoplay",
		"value" => array(
			esc_html__( "True", 'north' ) => "true",
			esc_html__( "False", 'north' ) => "false"
		),
		"description" => esc_html__( "Should the video play in a loop or not?", 'north' ),
		"group" => esc_html__( 'Video Background', 'north' ),
		"dependency" => Array('element' => "video_bg", 'value' => array('youtube','vimeo'))
	));

	vc_add_param("vc_row", array(
		"type" => "dropdown",
		"class" => "",
		"heading" => "Video Player Controls",
		"param_name" => "video_controls",
		"value" => array(
			esc_html__( "True", 'north' ) => "true",
			esc_html__( "False", 'north' ) => "false"
		),
		"description" => esc_html__( "Display the video player controls?", 'north' ),
		"group" => esc_html__( 'Video Background', 'north' ),
		"dependency" => Array('element' => "video_bg", 'value' => array('youtube'))
	));

	vc_add_param("vc_row", array(
		"type" => "dropdown",
		"class" => "",
		"heading" => "Mute Video",
		"param_name" => "video_mute",
		"value" => array(
			esc_html__( "True", 'north' ) => "true",
			esc_html__( "False", 'north' ) => "false"
		),
		"description" => esc_html__( "Mute the video?", 'north' ),
		"group" => esc_html__( 'Video Background', 'north' ),
		"dependency" => Array('element' => "video_bg", 'value' => array('youtube'))
	));

}

// VC Video

vc_add_param("vc_video", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => "Frame Style",
	"param_name" => "frame",
	"value" => array(
		esc_html__( "None", 'north' ) => "",
		"iPad" => "ipad"
	),
	"description" => esc_html__( "Enable the iPad frame around the video embed. If enabled, the video will be displayed with preset height and width.", 'north' ),
));

// VC Carousel

if ( ! has_filter( 'north_enable_vc_images_carousel_params' ) ) {
	vc_remove_param("vc_images_carousel","title");
	vc_remove_param("vc_images_carousel","el_class");
	vc_remove_param("vc_images_carousel","onclick");
	vc_remove_param("vc_images_carousel","custom_links");
	vc_remove_param("vc_images_carousel","custom_links_target");
	vc_remove_param("vc_images_carousel","mode");
	vc_remove_param("vc_images_carousel","speed");
	vc_remove_param("vc_images_carousel","slides_per_view");
	vc_remove_param("vc_images_carousel","autoplay");
	vc_remove_param("vc_images_carousel","hide_pagination_control");
	vc_remove_param("vc_images_carousel","hide_prev_next_buttons");
	vc_remove_param("vc_images_carousel","partial_view");
	vc_remove_param("vc_images_carousel","wrap");
}

vc_add_param("vc_images_carousel", array(
	"type" => "dropdown",
	"heading" => esc_html__("Captions", "north"),
	"param_name" => "captions",
	"class" => "hidden-label",
	"value" => array( esc_html__( "Yes, from media library", 'north' ) => "library", esc_html__( "Yes, custom", 'north' ) => "custom", esc_html__( "None", 'north' ) => 'none'),
	"description" => esc_html__("Choose a type of captions or completely disable them.", "north")
));

vc_add_param("vc_images_carousel", array(
	"type" => "exploded_textarea",
	"heading" => esc_html__("Custom Captions", "north"),
	"param_name" => "custom_captions",
	"class" => "hidden-label",
	"value" => "Slide 1 Title|Slide 1 Subtitle,Slide 2 Title|Slide 2 Subtitle,Slide 3 Title|Slide 3 Subtitle",
	"description" => esc_html__("Enter custom captions for your slider images. Separate each with new line (Enter)", "north"),
	"dependency" => Array('element' => "captions", 'value' => array("custom"))
));

vc_add_param("vc_images_carousel", array(
	"type" => "dropdown",
	"heading" => esc_html__("Fullscreen", "north"),
	"param_name" => "fullscreen",
	"class" => "hidden-label",
	"value" => array(esc_html__( "No", 'north' ) => "no", esc_html__( "Yes", 'north' ) => "yes"),
	"description" => esc_html__("Toggle the fullscreen size of the image slider.", "north")
));


// VC Tabs

if ( ! has_filter( 'north_enable_vc_tabs_params' ) ) {
	vc_remove_param("vc_tabs","el_class");
}

vc_add_param("vc_tabs", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => "Tabs Style",
	"param_name" => "style",
	"value" => array(
		esc_html__( "Default Tabs", 'north' ) => "",
		esc_html__( "Stylish Tabs", 'north' ) => "stylish"
	),
	"description" => esc_html__( "Tab's style.", 'north' )
));


// VC Separator

vc_add_param("vc_separator", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => "Fullscreen width",
	"param_name" => "fullwidth",
	"value" => array(
		esc_html__( "No", 'north' ) => "",
		esc_html__( "Yes", 'north' ) => "yes"
	),
	"description" => esc_html__( "Make the divider stretch to full size of the browser's viewport.", 'north' ),
));

// VC Text

vc_add_param("vc_column_text", array(
	"type" => "dropdown",
	"class" => "",
	"heading" => "Fullscreen width",
	"param_name" => "fullwidth",
	"value" => array(
		esc_html__( "No", 'north' ) => "",
		esc_html__( "Yes", 'north' ) => "yes"
	),
	"description" => esc_html__( "Make the divider stretch to full size of the browser's viewport.", 'north' ),
));

// VC Progress Bar

if ( ! has_filter( 'north_enable_vc_progress_bar_params' ) ) {
	vc_remove_param("vc_progress_bar","options");
	vc_remove_param("vc_progress_bar","el_class");
}

// VC Gallery

if ( ! has_filter( 'north_enable_vc_gallery_params' ) ) {
	vc_remove_param("vc_gallery","type");
	vc_remove_param("vc_gallery","interval");
	vc_remove_param("vc_gallery","el_class");
	vc_remove_param("vc_gallery","img_size");
}

vc_add_param("vc_gallery", array(
    "type" => "dropdown",
    "heading" => esc_html__("Image Size", "north"),
    "param_name" => "img_size",
    "description" => esc_html__('Choose an image size for your gallery thumbnails.', 'north'),
    'value' => array(
    	"875x360" => "875x360",
    	"800x600" => "800x600",
    	"460x368" => "460x368",
    	"Custom size" => "custom",
    )
));

vc_add_param("vc_gallery", array(
    "type" => "textfield",
    "heading" => esc_html__("Image size", "north"),
    "param_name" => "img_size_custom",
    "value" => "",
    "description" => esc_html__("Enter image size in pixels, e.g: 300x200 (Width x Height).", "north"),
    "dependency" => Array('element' => "img_size", 'value' => array("custom"))
));


// Font Awesome Icons Param

function vntd_init_icons_param($settings, $value) {
   return 'init_icons';
}
//add_shortcode_param('init_icons', 'vntd_init_icons_param', get_template_directory_uri().'/wpbakery/assets/icon-init.js');

function vntd_fontawesome_array() {
	$icons = array ('fa-glass' => 'fa-glass',
	  'fa-music' => 'fa-music',
	  'fa-search' => 'fa-search',
	  'fa-envelope-o' => 'fa-envelope-o',
	  'fa-heart' => 'fa-heart',
	  'fa-star' => 'fa-star',
	  'fa-star-o' => 'fa-star-o',
	  'fa-user' => 'fa-user',
	  'fa-film' => 'fa-film',
	  'fa-th-large' => 'fa-th-large',
	  'fa-th' => 'fa-th',
	  'fa-th-list' => 'fa-th-list',
	  'fa-check' => 'fa-check',
	  'fa-times' => 'fa-times',
	  'fa-search-plus' => 'fa-search-plus',
	  'fa-search-minus' => 'fa-search-minus',
	  'fa-power-off' => 'fa-power-off',
	  'fa-signal' => 'fa-signal',
	  'fa-cog' => 'fa-cog',
	  'fa-trash-o' => 'fa-trash-o',
	  'fa-home' => 'fa-home',
	  'fa-file-o' => 'fa-file-o',
	  'fa-clock-o' => 'fa-clock-o',
	  'fa-road' => 'fa-road',
	  'fa-download' => 'fa-download',
	  'fa-arrow-circle-o-down' => 'fa-arrow-circle-o-down',
	  'fa-arrow-circle-o-up' => 'fa-arrow-circle-o-up',
	  'fa-inbox' => 'fa-inbox',
	  'fa-play-circle-o' => 'fa-play-circle-o',
	  'fa-repeat' => 'fa-repeat',
	  'fa-refresh' => 'fa-refresh',
	  'fa-list-alt' => 'fa-list-alt',
	  'fa-lock' => 'fa-lock',
	  'fa-flag' => 'fa-flag',
	  'fa-headphones' => 'fa-headphones',
	  'fa-volume-off' => 'fa-volume-off',
	  'fa-volume-down' => 'fa-volume-down',
	  'fa-volume-up' => 'fa-volume-up',
	  'fa-qrcode' => 'fa-qrcode',
	  'fa-barcode' => 'fa-barcode',
	  'fa-tag' => 'fa-tag',
	  'fa-tags' => 'fa-tags',
	  'fa-book' => 'fa-book',
	  'fa-bookmark' => 'fa-bookmark',
	  'fa-print' => 'fa-print',
	  'fa-camera' => 'fa-camera',
	  'fa-font' => 'fa-font',
	  'fa-bold' => 'fa-bold',
	  'fa-italic' => 'fa-italic',
	  'fa-text-height' => 'fa-text-height',
	  'fa-text-width' => 'fa-text-width',
	  'fa-align-left' => 'fa-align-left',
	  'fa-align-center' => 'fa-align-center',
	  'fa-align-right' => 'fa-align-right',
	  'fa-align-justify' => 'fa-align-justify',
	  'fa-list' => 'fa-list',
	  'fa-outdent' => 'fa-outdent',
	  'fa-indent' => 'fa-indent',
	  'fa-video-camera' => 'fa-video-camera',
	  'fa-picture-o' => 'fa-picture-o',
	  'fa-pencil' => 'fa-pencil',
	  'fa-map-marker' => 'fa-map-marker',
	  'fa-adjust' => 'fa-adjust',
	  'fa-tint' => 'fa-tint',
	  'fa-pencil-square-o' => 'fa-pencil-square-o',
	  'fa-share-square-o' => 'fa-share-square-o',
	  'fa-check-square-o' => 'fa-check-square-o',
	  'fa-arrows' => 'fa-arrows',
	  'fa-step-backward' => 'fa-step-backward',
	  'fa-fast-backward' => 'fa-fast-backward',
	  'fa-backward' => 'fa-backward',
	  'fa-play' => 'fa-play',
	  'fa-pause' => 'fa-pause',
	  'fa-stop' => 'fa-stop',
	  'fa-forward' => 'fa-forward',
	  'fa-fast-forward' => 'fa-fast-forward',
	  'fa-step-forward' => 'fa-step-forward',
	  'fa-eject' => 'fa-eject',
	  'fa-chevron-left' => 'fa-chevron-left',
	  'fa-chevron-right' => 'fa-chevron-right',
	  'fa-plus-circle' => 'fa-plus-circle',
	  'fa-minus-circle' => 'fa-minus-circle',
	  'fa-times-circle' => 'fa-times-circle',
	  'fa-check-circle' => 'fa-check-circle',
	  'fa-question-circle' => 'fa-question-circle',
	  'fa-info-circle' => 'fa-info-circle',
	  'fa-crosshairs' => 'fa-crosshairs',
	  'fa-times-circle-o' => 'fa-times-circle-o',
	  'fa-check-circle-o' => 'fa-check-circle-o',
	  'fa-ban' => 'fa-ban',
	  'fa-arrow-left' => 'fa-arrow-left',
	  'fa-arrow-right' => 'fa-arrow-right',
	  'fa-arrow-up' => 'fa-arrow-up',
	  'fa-arrow-down' => 'fa-arrow-down',
	  'fa-share' => 'fa-share',
	  'fa-expand' => 'fa-expand',
	  'fa-compress' => 'fa-compress',
	  'fa-plus' => 'fa-plus',
	  'fa-minus' => 'fa-minus',
	  'fa-asterisk' => 'fa-asterisk',
	  'fa-exclamation-circle' => 'fa-exclamation-circle',
	  'fa-gift' => 'fa-gift',
	  'fa-leaf' => 'fa-leaf',
	  'fa-fire' => 'fa-fire',
	  'fa-eye' => 'fa-eye',
	  'fa-eye-slash' => 'fa-eye-slash',
	  'fa-exclamation-triangle' => 'fa-exclamation-triangle',
	  'fa-plane' => 'fa-plane',
	  'fa-calendar' => 'fa-calendar',
	  'fa-random' => 'fa-random',
	  'fa-comment' => 'fa-comment',
	  'fa-magnet' => 'fa-magnet',
	  'fa-chevron-up' => 'fa-chevron-up',
	  'fa-chevron-down' => 'fa-chevron-down',
	  'fa-retweet' => 'fa-retweet',
	  'fa-shopping-cart' => 'fa-shopping-cart',
	  'fa-folder' => 'fa-folder',
	  'fa-folder-open' => 'fa-folder-open',
	  'fa-arrows-v' => 'fa-arrows-v',
	  'fa-arrows-h' => 'fa-arrows-h',
	  'fa-bar-chart-o' => 'fa-bar-chart-o',
	  'fa-twitter-square' => 'fa-twitter-square',
	  'fa-facebook-square' => 'fa-facebook-square',
	  'fa-camera-retro' => 'fa-camera-retro',
	  'fa-key' => 'fa-key',
	  'fa-cogs' => 'fa-cogs',
	  'fa-comments' => 'fa-comments',
	  'fa-thumbs-o-up' => 'fa-thumbs-o-up',
	  'fa-thumbs-o-down' => 'fa-thumbs-o-down',
	  'fa-star-half' => 'fa-star-half',
	  'fa-heart-o' => 'fa-heart-o',
	  'fa-sign-out' => 'fa-sign-out',
	  'fa-linkedin-square' => 'fa-linkedin-square',
	  'fa-thumb-tack' => 'fa-thumb-tack',
	  'fa-external-link' => 'fa-external-link',
	  'fa-sign-in' => 'fa-sign-in',
	  'fa-trophy' => 'fa-trophy',
	  'fa-github-square' => 'fa-github-square',
	  'fa-upload' => 'fa-upload',
	  'fa-lemon-o' => 'fa-lemon-o',
	  'fa-phone' => 'fa-phone',
	  'fa-square-o' => 'fa-square-o',
	  'fa-bookmark-o' => 'fa-bookmark-o',
	  'fa-phone-square' => 'fa-phone-square',
	  'fa-twitter' => 'fa-twitter',
	  'fa-facebook' => 'fa-facebook',
	  'fa-github' => 'fa-github',
	  'fa-unlock' => 'fa-unlock',
	  'fa-credit-card' => 'fa-credit-card',
	  'fa-rss' => 'fa-rss',
	  'fa-hdd-o' => 'fa-hdd-o',
	  'fa-bullhorn' => 'fa-bullhorn',
	  'fa-bell' => 'fa-bell',
	  'fa-certificate' => 'fa-certificate',
	  'fa-hand-o-right' => 'fa-hand-o-right',
	  'fa-hand-o-left' => 'fa-hand-o-left',
	  'fa-hand-o-up' => 'fa-hand-o-up',
	  'fa-hand-o-down' => 'fa-hand-o-down',
	  'fa-arrow-circle-left' => 'fa-arrow-circle-left',
	  'fa-arrow-circle-right' => 'fa-arrow-circle-right',
	  'fa-arrow-circle-up' => 'fa-arrow-circle-up',
	  'fa-arrow-circle-down' => 'fa-arrow-circle-down',
	  'fa-globe' => 'fa-globe',
	  'fa-wrench' => 'fa-wrench',
	  'fa-tasks' => 'fa-tasks',
	  'fa-filter' => 'fa-filter',
	  'fa-briefcase' => 'fa-briefcase',
	  'fa-arrows-alt' => 'fa-arrows-alt',
	  'fa-users' => 'fa-users',
	  'fa-link' => 'fa-link',
	  'fa-cloud' => 'fa-cloud',
	  'fa-flask' => 'fa-flask',
	  'fa-scissors' => 'fa-scissors',
	  'fa-files-o' => 'fa-files-o',
	  'fa-paperclip' => 'fa-paperclip',
	  'fa-floppy-o' => 'fa-floppy-o',
	  'fa-square' => 'fa-square',
	  'fa-bars' => 'fa-bars',
	  'fa-list-ul' => 'fa-list-ul',
	  'fa-list-ol' => 'fa-list-ol',
	  'fa-strikethrough' => 'fa-strikethrough',
	  'fa-underline' => 'fa-underline',
	  'fa-table' => 'fa-table',
	  'fa-magic' => 'fa-magic',
	  'fa-truck' => 'fa-truck',
	  'fa-pinterest' => 'fa-pinterest',
	  'fa-pinterest-square' => 'fa-pinterest-square',
	  'fa-google-plus-square' => 'fa-google-plus-square',
	  'fa-google-plus' => 'fa-google-plus',
	  'fa-money' => 'fa-money',
	  'fa-caret-down' => 'fa-caret-down',
	  'fa-caret-up' => 'fa-caret-up',
	  'fa-caret-left' => 'fa-caret-left',
	  'fa-caret-right' => 'fa-caret-right',
	  'fa-columns' => 'fa-columns',
	  'fa-sort' => 'fa-sort',
	  'fa-sort-desc' => 'fa-sort-desc',
	  'fa-sort-asc' => 'fa-sort-asc',
	  'fa-envelope' => 'fa-envelope',
	  'fa-linkedin' => 'fa-linkedin',

	  'fa-undo' => 'fa-undo',
	  'fa-gavel' => 'fa-gavel',
	  'fa-tachometer' => 'fa-tachometer',
	  'fa-comment-o' => 'fa-comment-o',
	  'fa-comments-o' => 'fa-comments-o',
	  'fa-bolt' => 'fa-bolt',
	  'fa-sitemap' => 'fa-sitemap',
	  'fa-umbrella' => 'fa-umbrella',
	  'fa-clipboard' => 'fa-clipboard',
	  'fa-lightbulb-o' => 'fa-lightbulb-o',
	  'fa-exchange' => 'fa-exchange',
	  'fa-cloud-download' => 'fa-cloud-download',
	  'fa-cloud-upload' => 'fa-cloud-upload',
	  'fa-user-md' => 'fa-user-md',
	  'fa-stethoscope' => 'fa-stethoscope',
	  'fa-suitcase' => 'fa-suitcase',
	  'fa-bell-o' => 'fa-bell-o',
	  'fa-coffee' => 'fa-coffee',
	  'fa-cutlery' => 'fa-cutlery',
	  'fa-file-text-o' => 'fa-file-text-o',
	  'fa-building-o' => 'fa-building-o',
	  'fa-hospital-o' => 'fa-hospital-o',
	  'fa-ambulance' => 'fa-ambulance',
	  'fa-medkit' => 'fa-medkit',
	  'fa-fighter-jet' => 'fa-fighter-jet',
	  'fa-beer' => 'fa-beer',
	  'fa-h-square' => 'fa-h-square',
	  'fa-plus-square' => 'fa-plus-square',
	  'fa-angle-double-left' => 'fa-angle-double-left',
	  'fa-angle-double-right' => 'fa-angle-double-right',
	  'fa-angle-double-up' => 'fa-angle-double-up',
	  'fa-angle-double-down' => 'fa-angle-double-down',
	  'fa-angle-left' => 'fa-angle-left',
	  'fa-angle-right' => 'fa-angle-right',
	  'fa-angle-up' => 'fa-angle-up',
	  'fa-angle-down' => 'fa-angle-down',
	  'fa-desktop' => 'fa-desktop',
	  'fa-laptop' => 'fa-laptop',
	  'fa-tablet' => 'fa-tablet',
	  'fa-mobile' => 'fa-mobile',
	  'fa-circle-o' => 'fa-circle-o',
	  'fa-quote-left' => 'fa-quote-left',
	  'fa-quote-right' => 'fa-quote-right',
	  'fa-spinner' => 'fa-spinner',
	  'fa-circle' => 'fa-circle',
	  'fa-reply' => 'fa-reply',
	  'fa-github-alt' => 'fa-github-alt',
	  'fa-folder-o' => 'fa-folder-o',
	  'fa-folder-open-o' => 'fa-folder-open-o',
	  'fa-smile-o' => 'fa-smile-o',
	  'fa-frown-o' => 'fa-frown-o',
	  'fa-meh-o' => 'fa-meh-o',
	  'fa-gamepad' => 'fa-gamepad',
	  'fa-keyboard-o' => 'fa-keyboard-o',
	  'fa-flag-o' => 'fa-flag-o',
	  'fa-flag-checkered' => 'fa-flag-checkered',
	  'fa-terminal' => 'fa-terminal',
	  'fa-code' => 'fa-code',
	  'fa-reply-all' => 'fa-reply-all',
	  'fa-star-half-o' => 'fa-star-half-o',
	  'fa-location-arrow' => 'fa-location-arrow',
	  'fa-crop' => 'fa-crop',
	  'fa-code-fork' => 'fa-code-fork',
	  'fa-chain-broken' => 'fa-chain-broken',
	  'fa-question' => 'fa-question',
	  'fa-info' => 'fa-info',
	  'fa-exclamation' => 'fa-exclamation',
	  'fa-superscript' => 'fa-superscript',
	  'fa-subscript' => 'fa-subscript',
	  'fa-eraser' => 'fa-eraser',
	  'fa-puzzle-piece' => 'fa-puzzle-piece',
	  'fa-microphone' => 'fa-microphone',
	  'fa-microphone-slash' => 'fa-microphone-slash',
	  'fa-shield' => 'fa-shield',
	  'fa-calendar-o' => 'fa-calendar-o',
	  'fa-fire-extinguisher' => 'fa-fire-extinguisher',
	  'fa-rocket' => 'fa-rocket',
	  'fa-maxcdn' => 'fa-maxcdn',
	  'fa-chevron-circle-left' => 'fa-chevron-circle-left',
	  'fa-chevron-circle-right' => 'fa-chevron-circle-right',
	  'fa-chevron-circle-up' => 'fa-chevron-circle-up',
	  'fa-chevron-circle-down' => 'fa-chevron-circle-down',
	  'fa-html5' => 'fa-html5',
	  'fa-css3' => 'fa-css3',
	  'fa-anchor' => 'fa-anchor',
	  'fa-unlock-alt' => 'fa-unlock-alt',
	  'fa-bullseye' => 'fa-bullseye',
	  'fa-ellipsis-h' => 'fa-ellipsis-h',
	  'fa-ellipsis-v' => 'fa-ellipsis-v',
	  'fa-rss-square' => 'fa-rss-square',
	  'fa-play-circle' => 'fa-play-circle',
	  'fa-ticket' => 'fa-ticket',
	  'fa-minus-square' => 'fa-minus-square',
	  'fa-minus-square-o' => 'fa-minus-square-o',
	  'fa-level-up' => 'fa-level-up',
	  'fa-level-down' => 'fa-level-down',
	  'fa-check-square' => 'fa-check-square',
	  'fa-pencil-square' => 'fa-pencil-square',
	  'fa-external-link-square' => 'fa-external-link-square',
	  'fa-share-square' => 'fa-share-square',
	  'fa-compass' => 'fa-compass',
	  'fa-caret-square-o-down' => 'fa-caret-square-o-down',
	  'fa-caret-square-o-up' => 'fa-caret-square-o-up',
	  'fa-caret-square-o-right' => 'fa-caret-square-o-right',
	  'fa-eur' => 'fa-eur',
	  'fa-gbp' => 'fa-gbp',
	  'fa-usd' => 'fa-usd',
	  'fa-inr' => 'fa-inr',
	  'fa-jpy' => 'fa-jpy',
	  'fa-rub' => 'fa-rub',
	  'fa-krw' => 'fa-krw',
	  'fa-btc' => 'fa-btc',
	  'fa-file' => 'fa-file',
	  'fa-file-text' => 'fa-file-text',
	  'fa-sort-alpha-asc' => 'fa-sort-alpha-asc',
	  'fa-sort-alpha-desc' => 'fa-sort-alpha-desc',
	  'fa-sort-amount-asc' => 'fa-sort-amount-asc',
	  'fa-sort-amount-desc' => 'fa-sort-amount-desc',
	  'fa-sort-numeric-asc' => 'fa-sort-numeric-asc',
	  'fa-sort-numeric-desc' => 'fa-sort-numeric-desc',
	  'fa-thumbs-up' => 'fa-thumbs-up',
	  'fa-thumbs-down' => 'fa-thumbs-down',
	  'fa-youtube-square' => 'fa-youtube-square',
	  'fa-youtube' => 'fa-youtube',
	  'fa-xing' => 'fa-xing',
	  'fa-xing-square' => 'fa-xing-square',
	  'fa-youtube-play' => 'fa-youtube-play',
	  'fa-dropbox' => 'fa-dropbox',
	  'fa-stack-overflow' => 'fa-stack-overflow',
	  'fa-instagram' => 'fa-instagram',
	  'fa-flickr' => 'fa-flickr',
	  'fa-adn' => 'fa-adn',
	  'fa-bitbucket' => 'fa-bitbucket',
	  'fa-bitbucket-square' => 'fa-bitbucket-square',
	  'fa-tumblr' => 'fa-tumblr',
	  'fa-tumblr-square' => 'fa-tumblr-square',
	  'fa-long-arrow-down' => 'fa-long-arrow-down',
	  'fa-long-arrow-up' => 'fa-long-arrow-up',
	  'fa-long-arrow-left' => 'fa-long-arrow-left',
	  'fa-long-arrow-right' => 'fa-long-arrow-right',
	  'fa-apple' => 'fa-apple',
	  'fa-windows' => 'fa-windows',
	  'fa-android' => 'fa-android',
	  'fa-linux' => 'fa-linux',
	  'fa-dribbble' => 'fa-dribbble',
	  'fa-skype' => 'fa-skype',
	  'fa-foursquare' => 'fa-foursquare',
	  'fa-trello' => 'fa-trello',
	  'fa-female' => 'fa-female',
	  'fa-male' => 'fa-male',
	  'fa-gittip' => 'fa-gittip',
	  'fa-sun-o' => 'fa-sun-o',
	  'fa-moon-o' => 'fa-moon-o',
	  'fa-archive' => 'fa-archive',
	  'fa-bug' => 'fa-bug',
	  'fa-vk' => 'fa-vk',
	  'fa-weibo' => 'fa-weibo',
	  'fa-renren' => 'fa-renren',
	  'fa-pagelines' => 'fa-pagelines',
	  'fa-stack-exchange' => 'fa-stack-exchange',
	  'fa-arrow-circle-o-right' => 'fa-arrow-circle-o-right',
	  'fa-arrow-circle-o-left' => 'fa-arrow-circle-o-left',
	  'fa-caret-square-o-left' => 'fa-caret-square-o-left',
	  'fa-dot-circle-o' => 'fa-dot-circle-o',
	  'fa-wheelchair' => 'fa-wheelchair',
	  'fa-vimeo-square' => 'fa-vimeo-square',
	  'fa-try' => 'fa-try',
	  'fa-plus-square-o' => 'fa-plus-square-o',
	  'fa-space-shuttle' => 'fa-space-shuttle',
	  'fa-slack' => 'fa-slack',
	  'fa-envelope-square' => 'fa-envelope-square',
	  'fa-wordpress' => 'fa-wordpress',
	  'fa-openid' => 'fa-openid',
	  'fa-university' => 'fa-university',
	  'fa-graduation-cap' => 'fa-graduation-cap',
	  'fa-yahoo' => 'fa-yahoo',
	  'fa-google' => 'fa-google',
	  'fa-reddit' => 'fa-reddit',
	  'fa-reddit-square' => 'fa-reddit-square',
	  'fa-stumbleupon-circle' => 'fa-stumbleupon-circle',
	  'fa-stumbleupon' => 'fa-stumbleupon',
	  'fa-delicious' => 'fa-delicious',
	  'fa-digg' => 'fa-digg',
	  'fa-pied-piper' => 'fa-pied-piper',
	  'fa-pied-piper-alt' => 'fa-pied-piper-alt',
	  'fa-drupal' => 'fa-drupal',
	  'fa-joomla' => 'fa-joomla',
	  'fa-language' => 'fa-language',
	  'fa-fax' => 'fa-fax',

	  'fa-building' => 'fa-building',
	  'fa-child' => 'fa-child',
	  'fa-paw' => 'fa-paw',
	  'fa-spoon' => 'fa-spoon',
	  'fa-cube' => 'fa-cube',
	  'fa-cubes' => 'fa-cubes',
	  'fa-behance' => 'fa-behance',
	  'fa-behance-square' => 'fa-behance-square',
	  'fa-steam' => 'fa-steam',
	  'fa-steam-square' => 'fa-steam-square',
	  'fa-recycle' => 'fa-recycle',
	  'fa-car' => 'fa-car',
	  'fa-taxi' => 'fa-taxi',
	  'fa-tree' => 'fa-tree',
	  'fa-spotify' => 'fa-spotify',
	  'fa-deviantart' => 'fa-deviantart',
	  'fa-soundcloud' => 'fa-soundcloud',
	  'fa-database' => 'fa-database',
	  'fa-file-pdf-o' => 'fa-file-pdf-o',
	  'fa-file-word-o' => 'fa-file-word-o',
	  'fa-file-excel-o' => 'fa-file-excel-o',
	  'fa-file-powerpoint-o' => 'fa-file-powerpoint-o',
	  'fa-file-image-o' => 'fa-file-image-o',
	  'fa-file-archive-o' => 'fa-file-archive-o',
	  'fa-file-audio-o' => 'fa-file-audio-o',
	  'fa-file-video-o' => 'fa-file-video-o',
	  'fa-file-code-o' => 'fa-file-code-o',
	  'fa-vine' => 'fa-vine',
	  'fa-codepen' => 'fa-codepen',
	  'fa-jsfiddle' => 'fa-jsfiddle',
	  'fa-life-ring' => 'fa-life-ring',
	  'fa-circle-o-notch' => 'fa-circle-o-notch',
	  'fa-rebel' => 'fa-rebel',
	  'fa-empire' => 'fa-empire',
	  'fa-git-square' => 'fa-git-square',
	  'fa-git' => 'fa-git',
	  'fa-hacker-news' => 'fa-hacker-news',
	  'fa-tencent-weibo' => 'fa-tencent-weibo',
	  'fa-qq' => 'fa-qq',
	  'fa-weixin' => 'fa-weixin',
	  'fa-paper-plane' => 'fa-paper-plane',
	  'fa-paper-plane-o' => 'fa-paper-plane-o',
	  'fa-history' => 'fa-history',
	  'fa-circle-thin' => 'fa-circle-thin',
	  'fa-header' => 'fa-header',
	  'fa-paragraph' => 'fa-paragraph',
	  'fa-sliders' => 'fa-sliders',
	  'fa-share-alt' => 'fa-share-alt',
	  'fa-share-alt-square' => 'fa-share-alt-square',
	  'fa-angellist' => 'fa-angellist',
	  'fa-bomb' => 'fa-bomb');

	return $icons;
}

//
// Register new params
//

// Dropdown menu of pages

function param_pages_dropdown($settings, $value) {


	$return = '<div class="select_wrapper"><select name="'.$settings['param_name'].'" class="wpb_vc_param_value dropdown wpb-input wpb-select '.$settings['param_name'].' '.$settings['type'].'">';
	$return .= '<option value="">Select Page</option> ';

	$pages = get_pages();
	foreach ( $pages as $page ) {
		$selected = '';
		if($page->ID == $value) { $selected = 'selected="selected"'; }
		$return .= '<option value="'.$page->ID.'" '.$selected.'>'.$page->post_title.'</option>';
		$checked = "";
 	}

	$return .= '</select></div>';

	return $return;
}

// Dropdown menu of blog categories

function vntd_vc_blog_cats() {
	$blog_cats = array();
	$blog_categories = get_categories();

	foreach($blog_categories as $blog_cat) {
		$blog_cats[$blog_cat->name] = $blog_cat->term_id;
	}

	return $blog_cats;
}

// Dropdown menu of portfolio categories

function vntd_vc_portfolio_cats() {

	$portfolio_categories = get_categories('taxonomy=project-type');

	$portfolio_cats = array();

	foreach($portfolio_categories as $portfolio_cat) {
		$portfolio_cats[$portfolio_cat->name] = $portfolio_cat->slug;
	}

	return $portfolio_cats;

}

//
// Register new shortcodes:
//


// Carousel Portfolio

add_action("admin_init", "vntd_vc_shortcodes");

function vntd_vc_shortcodes() {

	// Link Target array
	$target_arr = array( esc_html__("Same window", "north") => "_self", esc_html__("New window", "north") => "_blank");
	$colors_arr = array( esc_html__("Accent Color", "north") => "accent", esc_html__("Blue", "north") => "blue", esc_html__("Turquoise", "north") => "turquoise", esc_html__("Green", "north") => "green", esc_html__("Orange", "north") => "orange", esc_html__("Red", "north") => "red", esc_html__("Dark", "north") => "dark",__("Grey", "north") => "grey", esc_html__("Custom Color", "north") => "custom");

	vc_map( array(
	   "name" => esc_html__("Portfolio Carousel", "north"),
	   "base" => "portfolio_carousel",
	   "class" => "font-awesome",
	   "icon"      => "fa-briefcase",
	   "controls" => "full",
	   "description" => esc_html__( "Carousel of portfolio posts", 'north' ),
	   "category" => array( esc_html__( "Carousels", 'north' ), esc_html__( "Posts", 'north' ) ),
	   "params" => array(
	      array(
	         "type" => "checkbox",
	         "class" => "hidden-label",
	         "value" => vntd_vc_portfolio_cats(),
	         "heading" => esc_html__("Portfolio Categories", "north"),
	         "param_name" => "cats",
	         "admin_label" => true,
	         "description" => esc_html__("Select categories to be displayed in your carousel. Leave blank for all.", "north")
	      ),
	      array(
	         "type" => "textfield",
	         "class" => "hidden-label",
	         "heading" => esc_html__("Number of posts to show", "north"),
	         "param_name" => "posts_nr",
	         "value" => "6",
	         "description" => esc_html__("This is a total number of posts in the carousel.", "north")
	      ),
           array(
               "type" => "dropdown",
               "class" => "hidden-label",
               "heading" => esc_html__("Hover Style", "north"),
               "param_name" => "hover_style",
               "value" => array("Default with icons" => "icons","Minimal (no icons)" => "minimal"),
               "description" => esc_html__("Choose portfolio thumbnail hover style.", "north")
           ),
           array(
               "type" => "textfield",
               "class" => "hidden-label",
               "heading" => esc_html__( "Carousel AutoPlay", "north"),
               "param_name" => "autoplay",
               "description" => esc_html__( "The carousel autoplay value. Leave blank for defaults (disabled). Example value: 5000 (to begin autoplay after 5 seconds).", "north"),
               "group" => esc_html__( "Carousel", "north" )
           ),
           array(
               "type" => "textfield",
               "class" => "hidden-label",
               "heading" => esc_html__( "Carousel Slide Speed", "north"),
               "param_name" => "slidespeed",
							 "value" => '700',
               "description" => esc_html__( "The carousel slide speed. Leave blank for default. Example value: 700 (0.7 second).", "north"),
               "group" => esc_html__( "Carousel", "north" )
           ),
           array(
               "type" => "textfield",
               "class" => "hidden-label",
               "heading" => esc_html__( "Carousel Pagination Speed", "north"),
               "param_name" => "paginationspeed",
							 "value" => '900',
               "description" => esc_html__( "The carousel pagination speed. Leave blank for default. Example value: 900 (0.9 second).", "north"),
               "group" => esc_html__( "Carousel", "north" )
           )
	   )
	));

	// Blog Carousel

	vc_map( array(
	   "name" => esc_html__("Blog Carousel", "north"),
	   "base" => "blog_carousel",
	   "class" => "font-awesome",
	   "icon"      => "fa-book",
	   "controls" => "full",
	   "description" => esc_html__( "Carousel of blog posts", 'north' ),
	   "category" => array( esc_html__( "Carousels", 'north' ), esc_html__( "Posts", 'north' ) ),
	   "params" => array(
	      array(
	         "type" => "checkbox",
	         "class" => "hidden-label",
	         "value" => vntd_vc_blog_cats(),
	         "heading" => esc_html__("Blog Categories", "north"),
	         "param_name" => "cats",
	         "admin_label" => true,
	         "description" => esc_html__("Select categories to be displayed in your carousel. Leave blank for all.", "north")
	      ),
	      array(
	         "type" => "textfield",
	         "class" => "hidden-label",
	         "heading" => esc_html__("Number of posts to show", "north"),
	         "param_name" => "posts_nr",
	         "value" => "6",
	         "description" => esc_html__("This is a total number of posts in the carousel.", "north")
	      ),
	      array(
	         "type" => "textfield",
	         "class" => "hidden-label",
	         "heading" => esc_html__("Post Title Height", "north"),
	         "param_name" => "title_height",
	         "value" => "",
	         "description" => esc_html__("Set an optional minimum height for the post titles. If some of your posts have a longer title and you want each item in the carousel perfectly aligned then please type a value like: 50px", "north")
	      ),
           array(
               "type" => "textfield",
               "class" => "hidden-label",
               "heading" => esc_html__( "Carousel AutoPlay", "north"),
               "param_name" => "autoplay",
               "description" => esc_html__( "The carousel autoplay value. Leave blank for defaults (disabled). Example value: 5000 (to begin autoplay after 5 seconds).", "north"),
               "group" => esc_html__( "Carousel", "north" )
           ),
           array(
               "type" => "textfield",
               "class" => "hidden-label",
               "heading" => esc_html__( "Carousel Slide Speed", "north"),
               "param_name" => "slidespeed",
               "description" => esc_html__( "The carousel slide speed. Leave blank for default. Example value: 700 (0.7 second).", "north"),
               "group" => esc_html__( "Carousel", "north" )
           ),
           array(
               "type" => "textfield",
               "class" => "hidden-label",
               "heading" => esc_html__( "Carousel Pagination Speed", "north"),
               "param_name" => "paginationspeed",
               "description" => esc_html__( "The carousel pagination speed. Leave blank for default. Example value: 900 (0.9 second).", "north"),
               "group" => esc_html__( "Carousel", "north" )
           )

	   )
	));

	// Testimonials Carousel

	vc_map( array(
	   "name" => esc_html__("Testimonials Carousel", "north"),
	   "base" => "testimonials",
	   "icon" => "fa-comments",
	   "class" => "font-awesome",
	   "category" => array( esc_html__( "Carousels", 'north' ) ),
	   "description" => esc_html__( "Fancy testimonials", 'north' ),
	   "params" => array(
			array(
			   "type" => "dropdown",
			   "description" => esc_html__( "Choose a style for your testimonials carousel", 'north' ),
			   "class" => "hidden-label",
			   "heading" => esc_html__("Testimonials Style", "north"),
			   "param_name" => "style",
			   "value" => array("Simple" => "simple","Expanded (client avatar, columned view)" => "expanded"),
			   "admin_label" => true
			),
			array(
				 "type" => "textfield",
				 "class" => "hidden-label",
				 "heading" => esc_html__("Number of posts to show", "north"),
				 "param_name" => "posts_nr",
				 "value" => "6"
			 ),
			 // Flexslider - "Simple" style
			 array(
					 "type" => "textfield",
					 "class" => "hidden-label",
					 "heading" => esc_html__( "Slideshow Speed", "north"),
					 "param_name" => "slideshowspeed",
					 "value" => "5000",
					 'dependency' => array(
		 					'element' => 'style',
		 					'value' => array( 'simple' )
		 				),
					 "description" => esc_html__( "The slideshow speed. Default value: 5000 (to change the slide after 5 seconds). Use 0 to disable.", "north" ),
					 "group" => esc_html__( "Slideshow", "north" )
			 ),
			 array(
					 "type" => "textfield",
					 "class" => "hidden-label",
					 "heading" => esc_html__( "Animation Speed", "north"),
					 "param_name" => "animationspeed",
					 "value" => '700',
					 'dependency' => array(
		 					'element' => 'style',
		 					'value' => array( 'simple' )
		 				),
					 "description" => esc_html__( "The carousel slide animation speed. Leave blank for default. Example value: 700 (0.7 second).", "north"),
					 "group" => esc_html__( "Slideshow", "north" )
			 ),
			 // OwlCarousel - "Extended" style
			 array(
					 "type" => "textfield",
					 "class" => "hidden-label",
					 "heading" => esc_html__( "Carousel AutoPlay", "north"),
					 "param_name" => "autoplay",
					 "value" => "6000",
					 'dependency' => array(
		 					'element' => 'style',
		 					'value' => array( 'expanded' )
		 				),
					 "description" => esc_html__( "The carousel autoplay value. Default value: 6000 (to begin autoplay after 6 seconds). Use 0 to disable autoplay.", "north"),
					 "group" => esc_html__( "Carousel", "north" )
			 ),
			 array(
					 "type" => "textfield",
					 "class" => "hidden-label",
					 "heading" => esc_html__( "Carousel Pagination Speed", "north"),
					 "param_name" => "paginationspeed",
					 "value" => '900',
					 'dependency' => array(
		 					'element' => 'style',
		 					'value' => array( 'expanded' )
		 				),
					 "description" => esc_html__( "The carousel pagination speed. Leave blank for default. Example value: 900 (0.9 second).", "north"),
					 "group" => esc_html__( "Carousel", "north" )
			 )
	   )
	));

	// Logos Carousel

	vc_map( array(
	   "name" => esc_html__("Logos Carousel", "north"),
	   "base" => "logos_carousel",
	   "icon" => "fa-css3",
	   "class" => "font-awesome",
	   "category" => array( esc_html__( "Carousels", 'north' ) ),
	   "description" => esc_html__( "Carousel of logo images", 'north' ),
	   "params" => array(
			array(
				'type' => 'attach_images',
				'heading' => esc_html__( 'Images', 'north' ),
				'param_name' => 'images',
				'value' => '',
				'description' => esc_html__( 'Select images from media library.', 'north' )
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'On click', 'north' ),
				'param_name' => 'onclick',
				'value' => array(
					esc_html__( 'Do nothing', 'north' ) => 'link_no',
					esc_html__( 'Open custom link', 'north' ) => 'custom_link'
				),
				'description' => esc_html__( 'Define action for onclick event if needed.', 'north' )
			),
			array(
				'type' => 'exploded_textarea',
				'heading' => esc_html__( 'Custom links', 'north' ),
				'param_name' => 'custom_links',
				'description' => esc_html__( 'Enter links for each logo here. Divide links with linebreaks (Enter) . ', 'north' ),
				'dependency' => array(
					'element' => 'onclick',
					'value' => array( 'custom_link' )
				)
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Columns', 'north' ),
				'param_name' => 'cols',
				'value' => array(
					'5' => '5',
					'4' => '4',
				 	'3' => '3'
				),
				'description' => esc_html__( 'Choose the number of items displayed in the carousel.', 'north' )
			),
			array(
					"type" => "textfield",
					"class" => "hidden-label",
					"heading" => esc_html__( "Logo Images Max Height", "north"),
					"param_name" => "logo_max_height",
					"value" => "",
					"description" => esc_html__( "Define the logo image max height in pixels i.e. 35px", "north")
			),
			array(
					"type" => "textfield",
					"class" => "hidden-label",
					"heading" => esc_html__( "Carousel AutoPlay", "north"),
					"param_name" => "autoplay",
					"value" => "6000",
					"description" => esc_html__( "The carousel autoplay value. Default value: 6000 (to begin autoplay after 6 seconds). Use 0 to disable autoplay.", "north"),
					"group" => esc_html__( "Carousel", "north" )
			),
			array(
					"type" => "textfield",
					"class" => "hidden-label",
					"heading" => esc_html__( "Carousel Slide Speed", "north"),
					"param_name" => "slidespeed",
					"value" => '700',
					"description" => esc_html__( "The carousel slide speed. Leave blank for default. Example value: 700 (0.7 second).", "north"),
					"group" => esc_html__( "Carousel", "north" )
			),
			array(
					"type" => "textfield",
					"class" => "hidden-label",
					"heading" => esc_html__( "Carousel Pagination Speed", "north"),
					"param_name" => "paginationspeed",
					"value" => '900',
					"description" => esc_html__( "The carousel pagination speed. Leave blank for default. Example value: 900 (0.9 second).", "north"),
					"group" => esc_html__( "Carousel", "north" )
			)
	   )
	));

	// Services Carousel

	vc_map( array(
	   "name" => esc_html__("Services Carousel", "north"),
	   "base" => "services_carousel",
	   "icon" => "fa-wrench",
	   "class" => "font-awesome",
	   "description" => esc_html__( "Carousel of services", 'north' ),
	   "category" => array( esc_html__( "Carousels", 'north' ) ),
	   "params" => array(
			array(
					 "type" => "textfield",
					 "class" => "hidden-label",
					 "admin_label" => true,
					 "heading" => esc_html__( "Number of services to show", "north" ),
					 "param_name" => "posts_nr",
					 "value" => "6"
			 ),
			 array(
					 "type" => "textfield",
					 "class" => "hidden-label",
					 "heading" => esc_html__( "Carousel AutoPlay", "north"),
					 "param_name" => "autoplay",
					 "value" 	=> '6000',
					 "description" => esc_html__( "The carousel autoplay value. Default value: 6000 (to begin autoplay after 6 seconds). Use 0 to disable autoplay.", "north"),
					 "group" => esc_html__( "Carousel", "north" )
			 ),
			 array(
					 "type" => "textfield",
					 "class" => "hidden-label",
					 "heading" => esc_html__( "Carousel Slide Speed", "north"),
					 "param_name" => "slidespeed",
					 "value" 	=> '700',
					 "description" => esc_html__( "The carousel slide speed. Leave blank for default. Example value: 700 (0.7 second).", "north"),
					 "group" => esc_html__( "Carousel", "north" )
			 ),
			 array(
					 "type" => "textfield",
					 "class" => "hidden-label",
					 "heading" => esc_html__( "Carousel Pagination Speed", "north"),
					 "param_name" => "paginationspeed",
					 "value" 	=> '900',
					 "description" => esc_html__( "The carousel pagination speed. Leave blank for default. Example value: 900 (0.9 second).", "north"),
					 "group" => esc_html__( "Carousel", "north" )
			 )
	   )
	));

	// Video Lightbox

	vc_map( array(
	   "name" => esc_html__("Video Lightbox", "north"),
	   "base" => "video_lightbox",
	   "icon" => "fa-play-circle-o",
	   "category" => array( esc_html__( "Media", 'north' ) ),
	   "class" => "font-awesome",
	   "description" => esc_html__( "Video in lightbox window", 'north' ),
	   "params" => array(
	   		array(
	   			'type' => 'textfield',
	   			'heading' => esc_html__( 'Video link', 'north' ),
	   			'param_name' => 'link',
	   			'admin_label' => true,
	   			'description' => sprintf( esc_html__( 'Link to the video. More about supported formats at %s.', 'north' ), '<a href="http://codex.wordpress.org/Embeds#Okay.2C_So_What_Sites_Can_I_Embed_From.3F" target="_blank">WordPress codex page</a>' )
	   		),
			array(
			 "type" => "textfield",
			 "class" => "hidden-label",
			 "heading" => esc_html__("Label", "north"),
			 "param_name" => "label",
			 "value" => "6",
			 "desc" => esc_html__( 'Text label visible under the Play icon', 'north' ),
			)
	   )
	));

	// Team Carousel

	vc_map( array(
	   "name" => esc_html__("Team Carousel", "north"),
	   "base" => "team_carousel",
	   "class" => "font-awesome",
	   "icon"      => "fa-users",
	   "controls" => "full",
	   "category" => array( esc_html__( "Carousels", 'north' ), esc_html__( "Posts", 'north' ) ),
	   "description" => esc_html__( "Carousel of your team members", 'north' ),
	   "params" => array(
	   	array(
	   	   "type" => "textfield",
	   	   "class" => "hidden-label",
	   	   "value" => "",
	   	   "heading" => esc_html__("Team Members ID", "north"),
	   	   "param_name" => "ids",
	   	   "description" => esc_html__("Insert IDs of specific team members to be displayed in this carousel. Leave blank to display all", "north")
	   	),
	      array(
	         "type" => "textfield",
	         "class" => "hidden-label",
	         "heading" => esc_html__("Number of posts to show", "north"),
	         "param_name" => "posts_nr",
	         "value" => "6",
	         "admin_label" => true,
	         "description" => esc_html__("Number of team members to be displayed in the carousel.", "north")
	      ),
	      array(
	         "type" => "dropdown",
	         "class" => "hidden-label",
	         "heading" => esc_html__("Lightbox Window with Member Details", "north"),
	         "param_name" => "lightbox",
	         "value" => array(esc_html__( "Yes", 'north' ) => "yes",esc_html__( "No", 'north' ) => "no"),
	         "description" => esc_html__("Disable the '+' icon that launches the lightbox window with the team member details.", "north")
	      ),
	      array(
	         "type" => "dropdown",
	         "class" => "hidden-label",
	         "heading" => esc_html__("Social icons link type", "north"),
	         "param_name" => "target",
	         "value" => array( esc_html__( "Open in a new tab", 'north' ) => "_blank", esc_html__( "Open in the same tab", 'north' ) => "_self" ),
	         "description" => esc_html__( "Decide if links should open in a new or same tab.", "north" )
	      ),
           array(
               "type" => "textfield",
               "class" => "hidden-label",
               "heading" => esc_html__( "Carousel AutoPlay", "north"),
               "param_name" => "autoplay",
               "description" => esc_html__( "The carousel autoplay value. Leave blank for defaults (disabled). Example value: 5000 (to begin autoplay after 5 seconds).", "north"),
               "group" => esc_html__( "Carousel", "north" )
           ),
           array(
               "type" => "textfield",
               "class" => "hidden-label",
               "heading" => esc_html__( "Carousel Slide Speed", "north"),
               "param_name" => "slidespeed",
               "description" => esc_html__( "The carousel slide speed. Leave blank for default. Example value: 700 (0.7 second).", "north"),
               "group" => esc_html__( "Carousel", "north" )
           ),
           array(
               "type" => "textfield",
               "class" => "hidden-label",
               "heading" => esc_html__( "Carousel Pagination Speed", "north"),
               "param_name" => "paginationspeed",
               "description" => esc_html__( "The carousel pagination speed. Leave blank for default. Example value: 900 (0.9 second).", "north"),
               "group" => esc_html__( "Carousel", "north" )
           )

	   )
	));

	// Portfolio Grid

	vc_map( array(
	   "name" => esc_html__("Portfolio Grid", "north"),
	   "base" => "portfolio_grid",
	   "class" => "font-awesome",
	   "icon"      => "fa-th",
	   "controls" => "full",
	   "category" => array( esc_html__( 'Posts', 'north' ) ),
	   "description" => esc_html__( "Portfolio posts grid", 'north' ),
	   "params" => array(
	      array(
	         "type" => "dropdown",
	         "class" => "hidden-label",
	         "heading" => esc_html__("Filtering menu", "north"),
	         "param_name" => "filter",
	         "value" => array(esc_html__( "Yes", 'north' ) => "yes",esc_html__( "No", 'north' ) => "no"),
	         "description" => esc_html__("Enable or disable the filterable effect.", "north")
	      ),
	      array(
	         "type" => "checkbox",
	         "class" => "hidden-label",
	         "value" => vntd_vc_portfolio_cats(),
	         "heading" => esc_html__("Portfolio Categories", "north"),
	         "param_name" => "cats",
	         "description" => esc_html__("Select categories to be displayed in the grid. Leave blank to display all.", "north")
	      ),
	      array(
	         "type" => "dropdown",
	         "class" => "hidden-label",
	         "heading" => esc_html__("Thumbnail Link Type", "north"),
	         "param_name" => "link_type",
	         "value" => array(
	         	esc_html__( 'Ajax expandable content', 'north' ) => 'ajax',
	         	esc_html__( 'Link to individual posts', 'north' ) => 'direct'
	          )
	      ),
	      array(
	         "type" => "dropdown",
	         "class" => "hidden-label",
	         "heading" => esc_html__("Thumbnail Spacing", "north"),
	         "param_name" => "thumb_space",
	         "value" => array(esc_html__( "Yes", 'north' ) => "yes",esc_html__( "No", 'north' ) => "no"),
	         "description" => esc_html__("Enable or disable the white space between post thumbnails.", "north")
	      ),
	      array(
	         "type" => "dropdown",
	         "class" => "hidden-label",
	         "heading" => esc_html__("Columns", "north"),
	         "param_name" => "cols",
	         "value" => array("5","4"),
	         "description" => esc_html__("Number of columns", "north"),
	         "dependency" => Array('element' => "thumb_space", 'value' => array("no"))
	      ),
	      array(
	         "type" => "dropdown",
	         "class" => "hidden-label",
	         "heading" => esc_html__("Thumbnail Size", "north"),
	         "std"	=> 'square',
	         "param_name" => "thumb_size",
	         "value" => array( esc_html__( "Square", 'north' ) => "square", esc_html__( "Original Aspect Ratio", 'north' ) => "auto"),
	         "description" => esc_html__("Portfolio grid thumbnails size.", "north")
	      ),
           array(
	         "type" => "textfield",
	         "class" => "hidden-label",
	         "heading" => esc_html__("Posts Number", "north"),
	         "param_name" => "posts_nr",
	         "value" => '',
	         "description" => esc_html__("Number of portfolio posts to be displayed. Leave blank for no limit.", "north")
	      ),
	      array(
	         "type" => "textfield",
	         "class" => "hidden-label",
	         "heading" => esc_html__("See More Link", "north"),
	         "param_name" => "more_url",
	         "value" => '',
	         "description" => esc_html__("Enter the URL of your Portfolio page. If not blank - a big, square PLUS icon will appear under the portfolio grid.", "north")
	      ),
	   )
	));

	$pixel_icons = array(
		array( 'vc_pixel_icon vc_pixel_icon-alert' => esc_html__( 'Alert', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-info' => esc_html__( 'Info', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-tick' => esc_html__( 'Tick', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-explanation' => esc_html__( 'Explanation', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-address_book' => esc_html__( 'Address book', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-alarm_clock' => esc_html__( 'Alarm clock', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-anchor' => esc_html__( 'Anchor', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-application_image' => esc_html__( 'Application Image', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-arrow' => esc_html__( 'Arrow', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-asterisk' => esc_html__( 'Asterisk', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-hammer' => esc_html__( 'Hammer', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-balloon' => esc_html__( 'Balloon', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-balloon_buzz' => esc_html__( 'Balloon Buzz', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-balloon_facebook' => esc_html__( 'Balloon Facebook', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-balloon_twitter' => esc_html__( 'Balloon Twitter', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-battery' => esc_html__( 'Battery', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-binocular' => esc_html__( 'Binocular', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-document_excel' => esc_html__( 'Document Excel', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-document_image' => esc_html__( 'Document Image', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-document_music' => esc_html__( 'Document Music', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-document_office' => esc_html__( 'Document Office', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-document_pdf' => esc_html__( 'Document PDF', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-document_powerpoint' => esc_html__( 'Document Powerpoint', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-document_word' => esc_html__( 'Document Word', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-bookmark' => esc_html__( 'Bookmark', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-camcorder' => esc_html__( 'Camcorder', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-camera' => esc_html__( 'Camera', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-chart' => esc_html__( 'Chart', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-chart_pie' => esc_html__( 'Chart pie', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-clock' => esc_html__( 'Clock', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-fire' => esc_html__( 'Fire', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-heart' => esc_html__( 'Heart', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-mail' => esc_html__( 'Mail', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-play' => esc_html__( 'Play', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-shield' => esc_html__( 'Shield', 'north' ) ),
		array( 'vc_pixel_icon vc_pixel_icon-video' => esc_html__( 'Video', 'north' ) ),
	);


	// Icon Box

	vc_map( array(
	   "name" => esc_html__("Icon Box", "north"),
	   "base" => "icon_box",
	   "class" => "font-awesome",
	   "icon" => "fa-check-circle-o",
	   "controls" => "full",
	   "category" => esc_html__( 'Content', 'north' ),
	   "description" => esc_html__( "Text with an icon", 'north' ),
	   "params" => array(
	      array(
	         "type" => "textfield",
	         "class" => "hidden-label",
	         "heading" => esc_html__("Title", "north"),
	         "param_name" => "title",
	         "holder" => "h4",
	         "value" => ''
	      ),
	      array(
	         "type" => "textarea",
	         "class" => "hidden-label",
	         "heading" => esc_html__("Text Content", "north"),
	         "param_name" => "text",
	         "holder" => "span",
	         "value" => '',
	      ),
	      array(
	        "type" => "textfield",
	        "heading" => esc_html__("URL (Link)", "north"),
	        "param_name" => "url",
	        "description" => esc_html__("Optional icon link.", "north")
	      ),
	      array(
	        "type" => "textfield",
	        "heading" => esc_html__("Link Title", "north"),
	        "param_name" => "link_title",
	        "value" => 'More Info',
	        "dependency" => Array('element' => "url", 'not_empty' => true)
	      ),
	      array(
	        "type" => "dropdown",
	        "heading" => esc_html__("Target", "north"),
	        "param_name" => "target",
	        "value" => $target_arr,
	        "dependency" => Array('element' => "url", 'not_empty' => true)
	      ),
	      array(
	         "type" => "dropdown",
	         "class" => "hidden-label",
	         "heading" => esc_html__("Style", "north"),
	         "param_name" => "style",
	         "value" => array(
	         	esc_html__( 'Default (Aligned Left)', 'north' ) => 'default',
	         	esc_html__( 'Big Centered', 'north' ) => 'centered',
	         	esc_html__( 'Aligned Left 2', 'north' ) => 'left',
	         	esc_html__( 'Aligned Right 2', 'north' ) => 'right'
	         	)
	      ),
	      array(
	        "type" => "dropdown",
	        "heading" => esc_html__("Animated", "north"),
	        "param_name" => "animated",
	        "value" => array(esc_html__( "Yes", 'north' ) => "yes",esc_html__( "No", 'north' ) => "no"),
	        "description" => esc_html__( "Enable the element fade in animation on scroll", 'north' ),
	      ),
	      	array(
	      	  "type" => "textfield",
	      	  "heading" => esc_html__("Animation Delay", "north"),
	      	  "param_name" => "animation_delay",
	      	  "value" => '100',
	      	  "description" => esc_html__( "Fade in animation delay. Can be used to create a nice delay effect if multiple elements of same type.", 'north' ),
	      	  "dependency" => Array('element' => "animated", 'value' => 'yes')
	      	),
	      array(
	      	'type' => 'dropdown',
	      	'heading' => esc_html__( 'Icon library', 'north' ),
	      	'value' => array(
	      		esc_html__( 'Font Awesome', 'north' ) => 'fontawesome',
	      		esc_html__( 'Open Iconic', 'north' ) => 'openiconic',
	      		esc_html__( 'Typicons', 'north' ) => 'typicons',
	      		esc_html__( 'Entypo', 'north' ) => 'entypo',
	      		esc_html__( 'Linecons', 'north' ) => 'linecons',
	      		esc_html__( 'Pixel', 'north' ) => 'pixelicons',
	      	),
	      	'param_name' => 'icon_type',
	      	'description' => esc_html__( 'Select icon library.', 'north' ),
	      ),
	      array(
	      	'type' => 'iconpicker',
	      	'heading' => esc_html__( 'Icon', 'north' ),
	      	'param_name' => 'icon_fontawesome',
	          'value' => 'fas fa-info-circle',
	      	'settings' => array(
	      		'emptyIcon' => false, // default true, display an "EMPTY" icon?
	      		'iconsPerPage' => 200, // default 100, how many icons per/page to display
	      	),
	      	'dependency' => array(
	      		'element' => 'icon_type',
	      		'value' => 'fontawesome',
	      	),
	      	'description' => esc_html__( 'Select icon from library.', 'north' ),
	      ),
	      array(
	      	'type' => 'iconpicker',
	      	'heading' => esc_html__( 'Icon', 'north' ),
	      	'param_name' => 'icon_openiconic',
	      	'settings' => array(
	      		'emptyIcon' => false, // default true, display an "EMPTY" icon?
	      		'type' => 'openiconic',
	      		'iconsPerPage' => 200, // default 100, how many icons per/page to display
	      	),
	      	'dependency' => array(
	      		'element' => 'icon_type',
	      		'value' => 'openiconic',
	      	),
	      	'description' => esc_html__( 'Select icon from library.', 'north' ),
	      ),
	      array(
	      	'type' => 'iconpicker',
	      	'heading' => esc_html__( 'Icon', 'north' ),
	      	'param_name' => 'icon_typicons',
	      	'settings' => array(
	      		'emptyIcon' => false, // default true, display an "EMPTY" icon?
	      		'type' => 'typicons',
	      		'iconsPerPage' => 200, // default 100, how many icons per/page to display
	      	),
	      	'dependency' => array(
	      	'element' => 'icon_type',
	      	'value' => 'typicons',
	      ),
	      	'description' => esc_html__( 'Select icon from library.', 'north' ),
	      ),
	      array(
	      	'type' => 'iconpicker',
	      	'heading' => esc_html__( 'Icon', 'north' ),
	      	'param_name' => 'icon_entypo',
	      	'settings' => array(
	      		'emptyIcon' => false, // default true, display an "EMPTY" icon?
	      		'type' => 'entypo',
	      		'iconsPerPage' => 300, // default 100, how many icons per/page to display
	      	),
	      	'dependency' => array(
	      		'element' => 'icon_type',
	      		'value' => 'entypo',
	      	),
	      ),
	      array(
	      	'type' => 'iconpicker',
	      	'heading' => esc_html__( 'Icon', 'north' ),
	      	'param_name' => 'icon_linecons',
	      	'settings' => array(
	      		'emptyIcon' => false, // default true, display an "EMPTY" icon?
	      		'type' => 'linecons',
	      		'iconsPerPage' => 200, // default 100, how many icons per/page to display
	      	),
	      	'dependency' => array(
	      		'element' => 'icon_type',
	      		'value' => 'linecons',
	      	),
	      	'description' => esc_html__( 'Select icon from library.', 'north' ),
	      ),
	      array(
	      	'type' => 'iconpicker',
	      	'heading' => esc_html__( 'Icon', 'north' ),
	      	'param_name' => 'icon_pixelicons',
	      	'settings' => array(
	      		'emptyIcon' => false, // default true, display an "EMPTY" icon?
	      		'type' => 'pixelicons',
	      		'source' => $pixel_icons,
	      	),
	      	'dependency' => array(
	      		'element' => 'icon_type',
	      		'value' => 'pixelicons',
	      	),
	      	'description' => esc_html__( 'Select icon from library.', 'north' ),
	      )
	   )
	));


	// Google Map

	vc_map( array(
	   "name" => esc_html__("Google Map", "north"),
	   "base" => "gmap",
	   "icon"      => "icon-wpb-map-pin",
	   "category" => esc_html__( 'Content', 'north' ),
	   "description" => esc_html__( "Map block", 'north' ),
	   "params" => array(
	      array(
	         "type" => "textfield",
	         "class" => "hidden-label",
	         "heading" => esc_html__("Location Latitude", "north"),
	         "param_name" => "lat",
	         "value" => '41.862274',
	         "description" => esc_html__( "Please insert the map address latitude if you have problems displaying it.", "north" ) . "<a target='_blank' href='https://veented.ticksy.com/article/14771/'>" . esc_html__( 'Learn more here', 'north' ) . "</a>.",
	      ),
	      array(
	         "type" => "textfield",
	         "class" => "hidden-label",
	         "heading" => esc_html__("Location Longitude", "north"),
	         "param_name" => "long",
	         "value" => '-87.701328',
	         "description" => esc_html__( "Please insert the map address longitude value.", "north" )
	      ),
	      array(
	         "type" => "textfield",
	         "class" => "hidden-label",
	         "heading" => esc_html__("Map Height", "north"),
	         "param_name" => "height",
	         "value" => '400',
	         "description" => esc_html__( "Height of the map element in pixels.", "north" )
	      ),
	      array(
	         "type" => "textfield",
	         "class" => "hidden-label",
	         "heading" => esc_html__("Map Zoom", "north"),
	         "param_name" => "zoom",
	         "value" => '15',
	         "description" => esc_html__("Choose the map zoom. Default value: 15", "north")
	      ),
	      array(
	         "type" => "textfield",
	         "class" => "hidden-label",
	         "heading" => esc_html__("Marker 1 Title", "north"),
	         "param_name" => "marker1_title",
	         "value" => 'Office 1',
	         "description" => esc_html__("Marker 1 Title.", "north")
	      ),
	      array(
	         "type" => "textfield",
	         "class" => "hidden-label",
	         "heading" => esc_html__("Marker 1 Text", "north"),
	         "param_name" => "marker1_text",
	         "value" => 'Your description goes here.',
	         "description" => esc_html__("Marker 1 description text.", "north")
	      ),
	      array(
	        "type" => "dropdown",
	        "heading" => esc_html__("Marker 1 Location", "north"),
	        "param_name" => "marker1_location",
	        "value" => array( esc_html__("Map Center", "north") => "center", esc_html__("Custom", "north") => "custom"),
	        "description" => esc_html__("The first marker location", "north")
	      ),
	      array(
	         "type" => "textfield",
	         "class" => "hidden-label",
	         "heading" => esc_html__("Marker 1 Custom Location", "north"),
	         "param_name" => "marker1_location_custom",
	         "value" => '441.863774,-87.721328',
	         "description" => esc_html__("Marker 1 custom location in latitude,longitude format.", "north")
	      ),
	      array(
	         "type" => "textfield",
	         "class" => "hidden-label",
	         "heading" => esc_html__("Marker 2 Title", "north"),
	         "param_name" => "marker2_title",
	         "value" => '',
	         "description" => esc_html__("Marker 2 Title.", "north")
	      ),
	      array(
	         "type" => "textfield",
	         "class" => "hidden-label",
	         "heading" => esc_html__("Marker 2 Text", "north"),
	         "param_name" => "marker2_text",
	         "value" => 'My secondary marker description.',
	         "dependency" => Array('element' => "marker2_title", 'not_empty' => true),
	         "description" => esc_html__("Marker 2 description text.", "north")
	      ),
	      array(
	         "type" => "textfield",
	         "class" => "hidden-label",
	         "heading" => esc_html__("Marker 2 Custom Location", "north"),
	         "param_name" => "marker2_location",
	         "value" => '41.858774,-87.685328',
	         "dependency" => Array('element' => "marker2_title", 'not_empty' => true),
	         "description" => esc_html__("Marker 2 location in latitude,longitude format.", "north")
	      )

	   )
	));

	vc_map( array(
	  "name" => esc_html__("Button", "north"),
	  "base" => "button",
	  "class" => "no-padding",
	  "icon" => "icon-wpb-ui-button",
	  "category" => esc_html__( 'Content', 'north' ),
	  "description" => esc_html__( "Simple button", 'north' ),
	  "params" => array(
	    array(
	      "type" => "textfield",
	      "heading" => esc_html__("Text on the button", "north"),
	      "holder" => "button",
	      "class" => "button",
	      "param_name" => "label",
	      "value" => esc_html__("Text on the button", "north"),
	      "description" => esc_html__("Text on the button.", "north")
	    ),
	    array(
	      "type" => "textfield",
	      "heading" => esc_html__("URL (Link)", "north"),
	      "param_name" => "url",
	      "description" => esc_html__("Button link.", "north")
	    ),
	    array(
	      "type" => "dropdown",
	      "heading" => esc_html__("Target", "north"),
	      "param_name" => "target",
	      "value" => $target_arr,
	      "dependency" => Array('element' => "url", 'not_empty' => true)
	    ),
	    array(
	      "type" => "dropdown",
	      "heading" => esc_html__("Button color", "north"),
	      "param_name" => "color",
	      "class" => "hidden-label",
	      "value" => $colors_arr,
	      "description" => esc_html__("Select button color.", "north"),
	      //"param_holder_class" => 'vc-colored-dropdown'
	    ),
		    array(
		      "type" => "colorpicker",
		      "heading" => esc_html__("Button custom color", "north"),
		      "param_name" => "customcolor",
		      "class" => "hidden-label",
		      "description" => esc_html__("Select custom color for your button.", "north"),
		      "dependency" => Array('element' => "color", 'value' => array('custom'))
		    ),

		array(
		  "type" => "dropdown",
		  "heading" => esc_html__("Size", "north"),
		  "param_name" => "size",
		  "class" => "hidden-label",
		  "value" => array( esc_html__("Regular size", "north") => "regular", esc_html__("Large", "north") => "large", esc_html__("Small", "north") => "small"),
		  "description" => esc_html__("Button size.", "north")
		),
		array(
		  "type" => "dropdown",
		  "heading" => esc_html__("Button Align", "north"),
		  "param_name" => "align",
		  "value" =>  array( esc_html__("Left", "north") => "", esc_html__("Centered", "north") => "center"),
		  "description" => esc_html__("Button align.", "north")
		),
		array(
		  "type" => "checkbox",
		  "heading" => esc_html__("Scroll Button?", "north"),
		  "param_name" => "scroll_btn",
		  "value" => array(
		  	esc_html__( "Yes", "north" ) => "yes",
		  ),
		  "description" => esc_html__( "Check this option to add a a scroll effect for the button. You can specify the scroll location by typing #section (section/row id) in the URL field.", "north" )
		),
	    array("type" => "init_icons"),
	    array(
	      "type" => "textfield",
	      "heading" => esc_html__("Margin Top", "north"),
	      "param_name" => "margin_top",
	      "description" => esc_html__("Change button's top margin value. Default value: 0px", "north")
	    ),
	    array(
	      "type" => "textfield",
	      "heading" => esc_html__("Margin Bottom", "north"),
	      "param_name" => "margin_bottom",
	      "description" => esc_html__("Change button's bottom margin value. Default value: 20px", "north")
	    )
	  )
	));

	// Special Heading

	vc_map( array(
	   "name" => esc_html__("Special Heading", "north"),
	   "base" => "special_heading",
	   "class" => "no-icon",
	   "icon" => "fa-header",
	   "description" => esc_html__( "Centered heading text", 'north' ),
	   "category" => esc_html__( 'Content', 'north' ),
	   "params" => array(
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Title", 'north'),
			    "param_name" => "title",
			    "holder" => "h5",
			    "description" => esc_html__("Main heading text.", 'north'),
			    "value" => "This is a Special Heading"
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Subtitle", 'north'),
			    "param_name" => "subtitle",
			    "holder" => "span",
			    "description" => esc_html__("Smaller text visible below the Main one.", 'north'),
			    "value" => "Isn't it awesome?"
			),
			array(
			  "type" => "dropdown",
			  "heading" => esc_html__("Animation", "north"),
			  "param_name" => "animated",
			  "class" => "hidden-label",
			  "value" => array( esc_html__("Yes", "north") => "yes", esc_html__("No", "north") => "no"),
			  "description" => esc_html__("Enable the fade-in animation of the heading elements on site scroll.", "north")
			),
			array(
			   "type" => "dropdown",
			   "class" => "hidden-label",
			   "heading" => esc_html__("Title Font", "north"),
			   "param_name" => "font",
			   "value" => array(
			   	'Primary' => '',
			   	'Secondary' => 'secondary'
			   	)
			),
			array(
			  "type" => "textfield",
			  "heading" => esc_html__("Margin Bottom", "north"),
			  "param_name" => "margin_bottom",
			  "class" => "hidden-label",
			  "value" => '30',
			  "description" => esc_html__("Bottom margin of the heading section, given in pixels. Default: 30", "north")
			)

	   )
	));

	// Callout Box

	vc_map( array(
	   "name" => esc_html__("Callout Box", "north"),
	   "base" => "callout_box",
	   "class" => "font-awesome",
	   "icon" => "fa-align-left",
	   "category" => esc_html__( 'Content', 'north' ),
	   "description" => esc_html__( "Nice blockquote", 'north' ),
	   "params" => array(
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Title", 'north'),
			    "param_name" => "title",
			    "holder" => "h3",
			    "description" => esc_html__("Main heading text.", 'north'),
			    "value" => "Callout"
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Subtitle", 'north'),
			    "param_name" => "subtitle",
			    "holder" => "span",
			    "description" => esc_html__("Smaller text visible below the Main one.", 'north'),
			    "value" => "Callout Box subtitle"
			)
	   )
	));

	//if(get_post_type($post_id) == 'portfolio') {
		vc_map( array(
		   "name" => esc_html__("Portfolio Post Details", "north"),
		   "base" => "portfolio_details",
		   "class" => "font-awesome",
		   "icon" => "fa-suitcase",
		   "description" => esc_html__( "Single portfolio post details", 'north' ),
		   "category" => esc_html__( 'Content', 'north' ),
		   "params" => array(
				array(
				   "type" => "dropdown",
				   "class" => "hidden-label",
				   "heading" => esc_html__("Style", "north"),
				   "param_name" => "style",
				   "value" => array(
				   	esc_html__( 'Style 1 (split in two columns)', "north") => 'style2',
				    esc_html__( 'Style 2', "north") => 'style1'
				   	)
				),
				array(
				    "type" => "textfield",
				    "heading" => esc_html__("Title", 'north'),
				    "param_name" => "title",
				    "holder" => "h5",
				    "description" => esc_html__("Main heading text.", 'north'),
				    "value" => "Project Details"
				),
				array(
				    "type" => "textarea_html",
				    "heading" => esc_html__("Text Content", 'north'),
				    "param_name" => "content",
				    "holder" => "div",
				    "description" => esc_html__("Smaller text visible below the Main one.", 'north'),
				    "value" => "Contrary to popular belief, Lorem Ipsum is not simply random text. It has rootsin piece of classical Latin literature from old. Richard McClintock, a Latin profes sor at Hampden-Sydney College in Virginia, looked up."
				),
				array(
				    "type" => "textfield",
				    "heading" => esc_html__("Secondary Title", 'north'),
				    "param_name" => "title2",
				    "holder" => "h5",
				    "description" => esc_html__("Secondary Title", 'north'),
				    "value" => "Project Description",
				    "dependency" => Array('element' => "style", 'value' => array('style2'))
				),

				array(
				    "type" => "textfield",
				    "heading" => esc_html__("Client Name", 'north'),
				    "param_name" => "client",
				    "holder"	=> "p",
				    "description" => esc_html__("Your project client name.", 'north'),
				    "value" => "Gold Eye Themes"
				),
				array(
				  "type" => "exploded_textarea",
				  "heading" => esc_html__("Skills", "north"),
				  "param_name" => "skills",
				  "holder" => "p",
				  "value"	=> 'Design,Photography,HTML,jQuery',
				  "description" => esc_html__('Enter the projects skills here. Divide each feature with linebreaks (Enter).', 'north')
				),
				array(
				    "type" => "textfield",
				    "heading" => esc_html__("Client Website", 'north'),
				    "param_name" => "client_website",
				    "description" => esc_html__("Your project client's website. Leave blank to hide.", 'north'),
				    "value" => ""
				),
				array(
				    "type" => "textfield",
				    "heading" => esc_html__("Button1 Label", 'north'),
				    "param_name" => "button1_label",
				    "description" => esc_html__("Primary button label.", 'north'),
				    "value" => "Live Preview"
				),
				array(
				    "type" => "textfield",
				    "heading" => esc_html__("Button1 URL", 'north'),
				    "param_name" => "button1_url",
				    "description" => esc_html__("Primary button URL.", 'north'),
				    "value" => "http://",
				    'dependency' => Array('element' => "button1_label", 'not_empty' => true)
				),
				array(
				    "type" => "textfield",
				    "heading" => esc_html__("Button2 Label", 'north'),
				    "param_name" => "button2_label",
				    "description" => esc_html__("Primary button label.", 'north'),
				    "value" => ""
				),
				array(
				    "type" => "textfield",
				    "heading" => esc_html__("Button2 URL", 'north'),
				    "param_name" => "button2_url",
				    "description" => esc_html__("Secondary button URL.", 'north'),
				    "value" => "http://",
				    'dependency' => Array('element' => "button1_label", 'not_empty' => true)
				)

			)
		));
	//}

	// Fancy Block

	vc_map( array(
	   "name" => esc_html__("Fancy Text Block", "north"),
	   "base" => "fancy_text_block",
	   "class" => "font-awesome",
	   "icon" => "fa-list-alt",
	   "category" => esc_html__( 'Content', 'north' ),
	   "description" => esc_html__( "Eye-catching block of text", 'north' ),
	   "params" => array(
	   		array(
	   		  "type" => "dropdown",
	   		  "heading" => esc_html__("Style", "north"),
	   		  "param_name" => "style",
	   		  "class" => "hidden-label",
	   		  "value" => array("Style 1" => "style1", "Style 2 (Transparent Background)" => "style2","Style 3 (Centered)" => "style3"),
	   		  "description" => esc_html__("Enable the fade-in animation of the heading elements on site scroll.", "north")
	   		),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Title", 'north'),
			    "param_name" => "title",
			    "holder" => "h2",
			    "description" => esc_html__("Main heading text.", 'north'),
			    "value" => "Fancy Title"
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Subtitle", 'north'),
			    "param_name" => "subtitle",
			    "holder" => "h4",
			    "description" => esc_html__("Smaller text visible below the Main one.", 'north'),
			    "value" => "Fancy Block subtitle"
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Alt Title", 'north'),
			    "param_name" => "alttitle",
			    "description" => esc_html__("Medium text visible above the Main one.", 'north'),
			    "value" => "#01"
			),
			array(
			    "type" => "textarea",
			    "heading" => esc_html__("Text Content", 'north'),
			    "param_name" => "text",
			    "description" => esc_html__("Fancy Text Block content.", 'north'),
			    "value" => "Text content"
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Button Label", 'north'),
			    "param_name" => "button_label",
			    "description" => esc_html__("Button Label.", 'north'),
			    "value" => "Continue"
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Button URL", 'north'),
			    "param_name" => "button_url",
			    "description" => esc_html__("Button URL.", 'north'),
			    "value" => "#"
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Plus Icon URL", 'north'),
			    "param_name" => "plus_url",
			    "description" => esc_html__("URL for the big, PLUS icon. Leave blank to hide the icon.", 'north'),
			    "value" => ""
			)
	   )
	));

	// Social Icons

	$social_icons_param = array(
	  "type" => "dropdown",
	  "heading" => esc_html__("Style", "north"),
	  "param_name" => "style",
	  "class" => "hidden-label",
	  "value" => array( esc_html__( "Square", 'north' ) => "square", esc_html__( "Round", 'north' ) => "round"),
	  "description" => esc_html__("Social icons style.", "north")
	);

	$social_icons_params_arr[] = $social_icons_param;

	$social_icons = array('mail' => "E-Mail",'facebook','twitter','instagram','mail' => "E-Mail",'tumblr','linkedin','youtube' => 'YouTube','vimeo','skype','google_plus' => 'Google Plus','flickr','dropbox','pinterest','dribbble','rss','snapchat','soundcloud');

	$icon_key = '';

	foreach($social_icons as $social_icon_key => $social_icon_name) {

		$icon_key = $social_icon_key;

		if(is_numeric($social_icon_key)) {
			$icon_key = $social_icon_name;
		}

		$social_icons_params_arr[] = array(
		    "type" => "textfield",
		    "heading" => ucfirst($social_icon_name),
		    "param_name" => $icon_key,
		    "holder" => "h5",
		    "description" => ucfirst($social_icon_name).' social site URL.'
		);
	}

	vc_map( array(
	   "name" => esc_html__("Social Icons", "north"),
	   "base" => "social_icons",
	   "class" => "font-awesome",
	   "icon" => "fa-twitter",
	   "category" => esc_html__( 'Content', 'north' ),
	   "description" => esc_html__( "List of social icons", 'north' ),
	   "params" => $social_icons_params_arr
	));

	// Simple Contact Form

	if ( class_exists( 'WPCF7' ) ) {

	vc_remove_element('contact-form-7');
	  global $wpdb;
	  $cf7 = $wpdb->get_results(
	    "
	    SELECT ID, post_title
	    FROM $wpdb->posts
	    WHERE post_type = 'wpcf7_contact_form'
	    "
	  );
	  $contact_forms = array();
	  if ($cf7) {
			$contact_forms[ esc_html__( '-- Select Form --', 'north' ) ] = 'none';
	    foreach ( $cf7 as $cform ) {
	      $contact_forms[$cform->post_title] = $cform->ID;
	    }
	  } else {
	    $contact_forms["No contact forms found"] = 0;
	  }
	  vc_map( array(
	    "base" => "vntd_contact_form",
	    "name" => esc_html__("Contact Form 7", "north"),
	    "icon" => "icon-wpb-contactform7",
	    "category" => esc_html__('Content', 'north'),
	    "description" => esc_html__('Place Contact Form7', 'north'),
	    "params" => array(
	      array(
	        "type" => "dropdown",
	        "heading" => esc_html__("Select contact form", "north"),
	        "param_name" => "id",
	        "admin_label" => true,
	        "value" => $contact_forms,
	        "description" => esc_html__("Choose previously created Contact Form 7 form from the drop down list.", "north")
	      ),
	      array(
	        "type" => "dropdown",
	        "heading" => esc_html__("Animated", "north"),
	        "param_name" => "animated",
	        "value" => array(esc_html__( "No", 'north' ) => "no", esc_html__( "Yes", 'north' ) => "yes"),
	        "description" => esc_html__("Enable fade in animation on scroll", "north")
	      )
	    )
	  ) );
	} // if contact form7 plugin active



	// Contact Block

	vc_map( array(
	   "name" => esc_html__("Contact Block", "north"),
	   "base" => "contact_block",
	   "class" => "font-awesome",
	   "icon" => "fa-envelope-square",
	   "description" => esc_html__( "Show off your contact data", 'north' ),
	   "category" => esc_html__( 'Content', 'north' ),
	   "params" => array(
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Phone Number", 'north'),
			    "param_name" => "phone",
			    "holder" => "div",
			    "description" => esc_html__("Your phone number.", 'north'),
			    "value" => "0123 456 789"
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Phone Number", 'north'),
			    "param_name" => "phone2",
			    "holder" => "div",
			    "description" => esc_html__("Secondary phone number.", 'north'),
			    "value" => ""
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Address", 'north'),
			    "param_name" => "address",
			    "holder" => "div",
			    "description" => esc_html__("Your address.", 'north'),
			    "value" => "North, Street Name 6901, Melbourne Australia"
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("E-Mail", 'north'),
			    "param_name" => "email",
			    "holder" => "div",
			    "description" => esc_html__("Your e-mail address.", 'north'),
			    "value" => "support@goldeyethemes.com"
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Facebook", 'north'),
			    "param_name" => "facebook",
			    "description" => esc_html__("Social site URL (optional).", 'north'),
			    "value" => ""
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Twitter", 'north'),
			    "param_name" => "twitter",
			    "description" => esc_html__("Social site URL (optional).", 'north'),
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Google+", 'north'),
			    "param_name" => "googleplus",
			    "description" => esc_html__("Social site URL (optional).", 'north'),
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Tumblr", 'north'),
			    "param_name" => "tumblr",
			    "description" => esc_html__("Social site URL (optional).", 'north'),
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Pinterest", 'north'),
			    "param_name" => "pinterest",
			    "description" => esc_html__("Social site URL (optional).", 'north'),
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("LinkedIn", 'north'),
			    "param_name" => "linkedin",
			    "description" => esc_html__("Social site URL (optional).", 'north'),
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Dribbble", 'north'),
			    "param_name" => "dribbble",
			    "description" => esc_html__("Social site URL (optional).", 'north'),
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Instagram", 'north'),
			    "param_name" => "instagram",
			    "description" => esc_html__("Social site URL (optional).", 'north'),
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("YouTube", 'north'),
			    "param_name" => "youtube",
			    "description" => esc_html__("Social site URL (optional).", 'north'),
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Soundcloud", 'north'),
			    "param_name" => "soundcloud",
			    "description" => esc_html__("Social site URL (optional).", 'north'),
			)

	   )
	));

	// Call to Action

	vc_map( array(
	   "name" => esc_html__("Call to Action", "north"),
	   "base" => "cta",
	   "class" => "",
	   "icon" => "icon-wpb-call-to-action",
	   "controls" => "edit_popup_delete",
	   "category" => esc_html__( 'Content', 'north' ),
	   "description" => esc_html__( "Heading text with buttons", 'north' ),
	   "params" => array(
	      array(
	          "type" => "textarea",
	          "heading" => esc_html__("Heading", 'north'),
	          "param_name" => "heading",
	          "value" => "Example Heading",
	          "description" => esc_html__("Enter your Call to Action Heading", 'north'),
	          "admin_label" => true
	      ),
	      array(
	          "type" => "textarea",
	          "heading" => esc_html__("Subtitle", 'north'),
	          "param_name" => "subtitle",
	          "value" => "Feel free to change the subtitle!",
	          "description" => esc_html__("Subtitle displayed under the main Heading.", 'north'),
	          "admin_label" => true
	      ),
	      array(
	          "type" => "textfield",
	          "heading" => esc_html__("Button 1 Label", 'north'),
	          "param_name" => "button1_title",
	          "description" => esc_html__("Enter the title for the first button", 'north'),
	          "value" => "Click me!",
	          "admin_label" => true
	      ),
	      array(
	          "type" => "textfield",
	          "heading" => esc_html__("Button 1 Sublabel (optional)", 'north'),
	          "param_name" => "button1_subtitle",
	          "description" => esc_html__("Optional button secondary label (available for Centered style).", 'north'),
	          "value" => "",
	          "dependency" => Array( 'element' => "button1_title", 'not_empty' => true )
	      ),
	      array(
	          "type" => "textfield",
	          "heading" => esc_html__("Button 1 Link", 'north'),
	          "param_name" => "button1_url",
	          "description" => esc_html__("Enter the URL the first button will link to", 'north'),
	          "value" => "http://",
	          "dependency" => Array( 'element' => "button1_title", 'not_empty' => true )
	      ),
	      array(
	          "type" => "textfield",
	          "heading" => esc_html__("Button 2 Label", 'north'),
	          "param_name" => "button2_title",
	          "description" => esc_html__("Enter the title for the second button", 'north'),
	          "value" => "",
	          "admin_label" => true
	      ),
	      array(
	          "type" => "textfield",
	          "heading" => esc_html__("Button 2 Sublabel (optional)", 'north'),
	          "param_name" => "button2_subtitle",
	          "description" => esc_html__("Optional button secondary label (available for Centered style).", 'north'),
	          "value" => "",
	          "dependency" => Array( 'element' => "button2_title", 'not_empty' => true )
	      ),
	      array(
	          "type" => "textfield",
	          "heading" => esc_html__("Button 2 Link", 'north'),
	          "param_name" => "button2_url",
	          "description" => esc_html__("Enter the URL the second button will link to", 'north'),
	          "value" => "http://",
	          "dependency" => Array( 'element' => "button2_title", 'not_empty' => true )
	      ),
	      array(
	        "type" => "dropdown",
	        "heading" => esc_html__("Buttons Link Target", "north"),
	        "param_name" => "buttons_target",
	        "value" => $target_arr
	      ),
	      array(
	      	"type" => "dropdown",
	      	"class" => "hidden-label",
	      	"value" => array(
	      		esc_html__( "Default (Floated)", 'north' ) => 'default',
	      		esc_html__( "Centered", 'north' ) => 'centered',
	      	),
	      	"heading" => esc_html__("Style", "north"),
	      	"description" => esc_html__('Style of your Call to Action area.', "north"),
	      	"param_name" => "style"
	      	),
	      array(
	         "type" => "colorpicker",
	         "heading" => esc_html__("Heading color", "north"),
	         "param_name" => "heading_color",
	         "value" => '',
	         "description" => esc_html__("Select the heading color. Leave blank for default.", "north"),
	      ),
	      array(
	         "type" => "colorpicker",
	         "heading" => esc_html__("Text color", "north"),
	         "param_name" => "text_color",
	         "value" => '',
	         "description" => esc_html__("Select text color. Leave blank for default.", "north"),
	      ),
	      array(
	      	"type" => "dropdown",
	      	"class" => "hidden-label",
	      	"value" => array(
	      		esc_html__( "Dark", 'north' ) => 'dark',
	      		esc_html__( "White", 'north' ) => 'white',
	      	),
	      	"heading" => esc_html__("Button Color", "north"),
	      	"description" => esc_html__('Color of your Call to Action area buttons.', "north"),
	      	"param_name" => "button_color"
	      	),
	      array(
	          "type" => "textfield",
	          "heading" => esc_html__("Margin bottom", 'north'),
	          "param_name" => "margin_bottom",
	          "value" => "0",
	          "dependency" => Array('element' => "fullscreen", 'value' => array("yes"))
	      )
	   )
	));

	// Centered Heading

	vc_map( array(
	   "name" => esc_html__("Pricing Box", "north"),
	   "base" => "pricing_box",
	   "class" => "font-awesome",
	   "icon" => "fa-usd",
	   "category" => esc_html__( 'Content', 'north' ),
	   "description" => esc_html__( "Product box with prices", 'north' ),
	   "params" => array(
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Box Title", 'north'),
			    "param_name" => "title",
			    "description" => esc_html__("Your Pricing Box title", 'north'),
			    "value" => "",
			    "admin_label" => true
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Price", 'north'),
			    "param_name" => "price",
			    "description" => esc_html__("Pricing Box price", 'north'),
			    "value" => "$99",
			    "admin_label" => true
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Period", 'north'),
			    "param_name" => "period",
			    "description" => esc_html__("Pricing Box period", 'north'),
			    "value" => "per year"
			),
			array(
			  "type" => "exploded_textarea",
			  "heading" => esc_html__("Features", "north"),
			  "param_name" => "features",
			  "description" => esc_html__('Enter features here. Divide each feature with linebreaks (Enter).', 'north')
			),
			array(
				"type" => "dropdown",
				"class" => "hidden-label",
				"value" => array(
					esc_html__("Not Featured", 'north' ) => 'no',
					esc_html__("Featured", 'north' ) => 'yes',
				),
				"heading" => esc_html__("Featured?", "north"),
				"description" => esc_html__('Make the box stand out from the crew.', "north"),
				"param_name" => "featured"
				),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Button Label", 'north'),
			    "param_name" => "button_label",
			    "description" => esc_html__("Text visible on the box button", 'north'),
			    "value" => "Buy Now"
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Button URL", 'north'),
			    "param_name" => "button_url",
			    "description" => esc_html__("Button URL, start with http://", 'north'),
			    "value" => "",
			    'dependency' => Array('element' => "button_label", 'not_empty' => true)
			),
			array(
			  "type" => "dropdown",
			  "heading" => esc_html__("Animated", "north"),
			  "param_name" => "animated",
			  "value" => array(esc_html__( "Yes", 'north' ) => "yes",esc_html__( "No", 'north' ) => "no"),
			  "description" => esc_html__( "Enable the element fade in animation on scroll", 'north' ),
			),
				array(
				  "type" => "textfield",
				  "heading" => esc_html__("Animation Delay", "north"),
				  "param_name" => "animation_delay",
				  "value" => '100',
				  "description" => esc_html__( "Fade in animation delay. Can be used to create a nice delay effect if multiple elements of same type.", 'north' ),
				  "dependency" => Array('element' => "animated", 'value' => 'yes')
				),
	   )
	));

	// Centered Heading

	vc_map( array(
	   "name" => esc_html__("Counter", "north"),
	   "base" => "counter",
	   "class" => "font-awesome",
	   "icon" => "fa-clock-o",
	   "category" => esc_html__( 'Content', 'north' ),
	   "description" => esc_html__( "Countdown numbers", 'north' ),
	   "params" => array(
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Counter Title", 'north'),
			    "param_name" => "title",
			    "description" => esc_html__("Your Counter title.", 'north'),
			    "value" => "Days",
			    "admin_label" => true
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Number value", 'north'),
			    "param_name" => "number",
			    "description" => esc_html__("Value of the counter number.", 'north'),
			    "value" => "100",
			    "admin_label" => true
			)
	   )
	));


	// Fullscreen slider

	vc_map( array(
	   "name" => esc_html__( "Fullscreen Text Slider", "north" ),
	   "base" => "vntd_fullscreen_slider",
	   "class" => "font-awesome",
	   "icon" => "fa-arrows-alt",
	   "category" => esc_html__( 'Media', 'north' ),
	   "params" => array(
			array(
				'type' => 'attach_images',
				'heading' => esc_html__( 'Background Images', 'north' ),
				'param_name' => 'images',
				'value' => '',
				'description' => esc_html__( 'Select images from media library. Leave blank to use row\'s background image/video.', 'north' )
			),
			array(
			    "type" => "textarea",
			    "heading" => esc_html__("Static Text", 'north'),
			    "param_name" => "text_static",
			    "description" => esc_html__("Static text displayed on the slider.", 'north'),
			    "value" => "Hello there",
			    "admin_label" => true
			),
			array(
				'type' => 'exploded_textarea',
				'heading' => esc_html__( 'Dynamic Text Lines', 'north' ),
				'param_name' => 'text_dynamic',
				"value"	=> 'Welcome to North,We are Designers,We love to Design',
				'description' => esc_html__( 'Dynamic Text Lines are displayed one after another as slides. Separate each line with linebreaks (Enter). To have a comma please use a double semicolon like: We have over 2;;435 clients.', 'north' )
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Slider Style', 'north' ),
				'param_name' => 'style',
				'value' => array(
					esc_html__( 'Style 1', 'north' ) => 'style1',
					esc_html__( 'Style 2 (with services slider)', 'north' ) => 'style2'
				),
				'description' => esc_html__( 'Choose a style for the slider.', 'north' )
			),
			array(
			    "type" => "dropdown",
			    "heading" => esc_html__("Display icons?", 'north'),
			    "param_name" => "service_icons",
			    "description" => esc_html__("Enable or disable icons to be displayed next to each service, defined in the service post.", 'north'),
			    'value' => array(
			    	esc_html__( 'No', 'north' ) => 'no',
			    	esc_html__( 'Yes', 'north' ) => 'yes'
			    ),
			    'dependency' => Array('element' => "style", 'value' => 'style2')
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Services post number.", 'north'),
			    "param_name" => "posts_nr",
			    "description" => esc_html__("Number of services type of posts to be displayed in the slider.", 'north'),
			    "value" => "6",
			    'dependency' => Array('element' => "style", 'value' => 'style2')
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Background Overlay', 'north' ),
				'param_name' => 'bg_overlay',
				'value' => array(
					esc_html__( 'Dark 1', 'north' ) => 'dark1',
					esc_html__( 'Dark 2', 'north' ) => 'dark2',
					esc_html__( 'Dark pattern', 'north' ) => 'dots',
					esc_html__( 'White pattern', 'north' ) => 'dots_white',
					esc_html__( 'None', 'north' )	=> 'none'
				),
				'description' => esc_html__( 'Choose the slider overlay background type.', 'north' )
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Button 1 Label", 'north'),
			    "param_name" => "button1_label",
			    "description" => esc_html__("First button label.", 'north'),
			    "value" => "Read More"
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Button 1 URL", 'north'),
			    "param_name" => "button1_url",
			    "description" => esc_html__("First button URL.", 'north'),
			    "value" => "#",
			    'dependency' => Array('element' => "button1_label", 'not_empty' => true)
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Button 2 Label", 'north'),
			    "param_name" => "button2_label",
			    "description" => esc_html__("Second button label.", 'north'),
			    "value" => ""
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Button 2 URL", 'north'),
			    "param_name" => "button2_url",
			    "description" => esc_html__("Second button URL.", 'north'),
			    "value" => "",
			    'dependency' => Array('element' => "button2_label", 'not_empty' => true)
			),
			array(
			  "type" => "dropdown",
			  "heading" => esc_html__("Animated", "north"),
			  "param_name" => "animated",
			  "value" => array(esc_html__( "No", 'north' ) => "no",esc_html__( "Yes", 'north' ) => "yes"),
			  "description" => esc_html__( "Enable the element fade in animation on scroll", 'north' ),
			),
			array(
			    "type" => "dropdown",
			    "heading" => esc_html__("Buttons Color", 'north'),
			    "param_name" => "buttons_color",
			    "description" => esc_html__("Color of your slider buttons.", 'north'),
			    "value" => array(esc_html__( "Dark", 'north' ) => "dark",esc_html__( "Light", 'north' ) => "light")
			),
			array(
			    "type" => "textfield",
			    "heading" => esc_html__("Plus Icon URL", 'north'),
			    "param_name" => "plus_url",
			    "holder" => "span",
			    "description" => esc_html__("URL for the big, PLUS icon. Leave blank to hide the icon.", 'north'),
			    "value" => ""
			),
			// Text slider
			array(
					"type" => "textfield",
					"class" => "hidden-label",
					"heading" => esc_html__( "Background Slider Speed", "north" ),
					"param_name" => "bg_sliderspeed",
					"value" => "12000",
					"description" => esc_html__( "Background slider speed (if more than one bg image added). Default value: 12000 (to change the slide after 12 seconds). Use 0 to disable.", "north" ),
					"group" => esc_html__( "Slider/Carousel", "north" )
			),
			array(
					"type" => "textfield",
					"class" => "hidden-label",
					"heading" => esc_html__( "Background Slider Animation Speed", "north" ),
					"param_name" => "bg_animationspeed",
					"value" => "800",
					"description" => esc_html__( "Background slider animation speed. Default value: 800 (0.8 second).", "north" ),
					"group" => esc_html__( "Slider/Carousel", "north" )
			),
			array(
					"type" => "dropdown",
					"class" => "hidden-label",
					"heading" => esc_html__( "Background Slider Animation", "north" ),
					"param_name" => "bg_animationtype",
					'value' => array(
						esc_html__( 'Fade', 'north' ) => 'fade',
						esc_html__( 'Slide', 'north' ) => 'slide'
					),
					"description" => esc_html__( "Background slider animation type. Default: fade.", "north" ),
					"group" => esc_html__( "Slider/Carousel", "north" )
			),
			array(
					"type" => "textfield",
					"class" => "hidden-label",
					"heading" => esc_html__( "Text Slider Speed", "north" ),
					"param_name" => "slideshowspeed",
					"value" => "5000",
					'dependency' => array(
						 'element' => 'style',
						 'value' => array( 'style1', 'style2' )
					 ),
					"description" => esc_html__( "The text slider speed. Default value: 5000 (to change the slide after 5 seconds). Use 0 to disable.", "north" ),
					"group" => esc_html__( "Slider/Carousel", "north" )
			),
			array(
					"type" => "textfield",
					"class" => "hidden-label",
					"heading" => esc_html__( "Text Slider Animation Speed", "north" ),
					"param_name" => "animationspeed",
					"value" => '600',
					'dependency' => array(
						 'element' => 'style',
						 'value' => array( 'style1', 'style2' )
					 ),
					"description" => esc_html__( "The text slider slide animation speed. Leave blank for default. Example value: 600 (0.6 second).", "north"),
					"group" => esc_html__( "Slider/Carousel", "north" )
			),
			// Style1 text carousel settings
			array(
					"type" => "textfield",
					"class" => "hidden-label",
					"heading" => esc_html__( "Services Carousel AutoPlay", "north"),
					"param_name" => "autoplay",
					"value" => "15000",
					'dependency' => array(
						 'element' => 'style',
						 'value' => array( 'style2' )
					 ),
					"description" => esc_html__( "Services Carousel autoplay value. Default value: 15000 (to begin autoplay after 15 seconds). Use 0 to disable autoplay.", "north"),
					"group" => esc_html__( "Slider/Carousel", "north" )
			),
			array(
					"type" => "textfield",
					"class" => "hidden-label",
					"heading" => esc_html__( "Services Carousel Slide Speed", "north"),
					"param_name" => "slidespeed",
					"value" => '400',
					'dependency' => array(
						 'element' => 'style',
						 'value' => array( 'style2' )
					 ),
					"description" => esc_html__( "Services Carousel slide speed. Leave blank for default. Example value: 400 (0.4 second).", "north"),
					"group" => esc_html__( "Slider/Carousel", "north" )
			),
			array(
					"type" => "textfield",
					"class" => "hidden-label",
					"heading" => esc_html__( "Services Carousel Pagination Speed", "north"),
					"param_name" => "paginationspeed",
					"value" => '600',
					'dependency' => array(
						 'element' => 'style',
						 'value' => array( 'style2' )
					 ),
					"description" => esc_html__( "Services Carousel pagination speed. Leave blank for default. Example value: 600 (0.6 second).", "north"),
					"group" => esc_html__( "Slider/Carousel", "north" )
			)
	   )
	));


	vc_map( array(
		   "name" => esc_html__("North Tabs", 'north'),
		   "base" => "north_tabs",
		   "class" => "font-awesome",
		   "icon" => "fa-picture-o",
		   "description" => esc_html__( "Fancy North Theme Tabs.", 'north' ),
		   "category" => esc_html__( 'Content', 'north' ),
		   "params" => array(
		   		array(
		   			'type' => 'param_group',
		   			'heading' => esc_html__( 'Tabs', 'north' ),
		   			'param_name' => 'tabs',
		   			'description' => esc_html__( 'Add tabs.', 'north' ),
		   			'value' => urlencode( json_encode( array(
		   				array(
		   					'title' => 'Movie',
		   					'heading' => 'Movie',
		   					'text'	=> 'Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Rich McClintock not simply. There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form.'
		   				),
		   				array(
	   						'title' => 'Landing',
	   						'heading' => 'Landing',
	   						'text'	=> 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even snormally believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.'
	   					),
	   					array(
   							'title' => 'Design',
   							'heading' => 'Design',
   							'text'	=> 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using ‘Content here, content here’, making it look like readable English.'
   						),
   						array(
							'title' => 'Art',
							'heading' => 'Art',
							'text'	=> 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using ‘Content here, content here’, making it look like readable English.'
						),
		   			) ) ),
		   			'params' => array(
		   				array(
	   						'type' => 'textfield',
	   						'heading' => esc_html__( 'Title', 'north' ),
	   						'param_name' => 'title',
	   						'description' => esc_html__( 'Tab title, displayed in the diamond box.', 'north' ),
	   						'admin_label' => true,
	   					),
		   				array(
		   					'type' => 'textfield',
		   					'heading' => esc_html__( 'Text Heading', 'north' ),
		   					'param_name' => 'heading',
		   					'description' => esc_html__( 'Text content heading.', 'north' ),
		   					'admin_label' => true,
		   				),
		   				array(
		   					'type' => 'textarea',
		   					'heading' => esc_html__( 'Text Content', 'north' ),
		   					'param_name' => 'text',
		   					'description' => esc_html__( 'Text content. You can use (br) shortcode to break the line of text.', 'north' ),
		   				),
		   			),
		   		),
		   	)
	));

}


?>
